/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.socket.EzySocketAbstractEventHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroup;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroupRemover;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnection;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnectionQueue;

public class EzySocketDisconnectionHandler
extends EzySocketAbstractEventHandler {
    protected EzySocketDisconnectionQueue disconnectionQueue;
    protected EzySocketDataHandlerGroupRemover dataHandlerGroupRemover;

    @Override
    public void handleEvent() {
        this.processDisconnectionQueue();
    }

    public void destroy() {
        EzyProcessor.processWithLogException(() -> this.disconnectionQueue.clear());
    }

    private void processDisconnectionQueue() {
        try {
            EzySocketDisconnection disconnection = this.disconnectionQueue.take();
            this.processDisconnection(disconnection);
        }
        catch (InterruptedException e) {
            this.logger.info("disconnection-handler thread interrupted");
        }
        catch (Throwable throwable) {
            this.logger.warn("problems in disconnection-handler, thread", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDisconnection(EzySocketDisconnection disconnection) {
        try {
            EzySession session = disconnection.getSession();
            EzyConstant disconnectReason = disconnection.getDisconnectReason();
            EzySocketDataHandlerGroup handlerGroup = this.removeDataHandlerGroup(session);
            if (handlerGroup != null) {
                handlerGroup.fireChannelInactive(disconnectReason);
            } else {
                this.logger.warn("has no handler group with session: {}, ignore disconnection: {}", (Object)session, (Object)disconnection);
            }
        }
        finally {
            disconnection.release();
        }
    }

    protected EzySocketDataHandlerGroup removeDataHandlerGroup(EzySession session) {
        return this.dataHandlerGroupRemover.removeHandlerGroup(session);
    }

    public void setDisconnectionQueue(EzySocketDisconnectionQueue disconnectionQueue) {
        this.disconnectionQueue = disconnectionQueue;
    }

    public void setDataHandlerGroupRemover(EzySocketDataHandlerGroupRemover dataHandlerGroupRemover) {
        this.dataHandlerGroupRemover = dataHandlerGroupRemover;
    }
}

