/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.net;

import com.tvd12.ezyhttp.core.net.PathVariables;
import java.util.HashMap;
import java.util.Map;

public class URITree {
    protected String uri;
    protected Map<String, URITree> children;

    public void addURI(String uri) {
        String[] paths;
        URITree lastChild = this;
        for (String s : paths = uri.split("/")) {
            URITree child;
            String path;
            if (lastChild.children == null) {
                lastChild.children = new HashMap<String, URITree>();
            }
            if (PathVariables.isPathVariable(path = s)) {
                path = "{}";
            }
            if ((child = lastChild.children.get(path)) == null) {
                child = new URITree();
                lastChild.children.put(path, child);
            }
            lastChild = child;
        }
        lastChild.uri = uri;
    }

    public String getMatchedURI(String uri) {
        String[] paths;
        URITree lastChild = this;
        for (String path : paths = uri.split("/")) {
            if (lastChild.children == null) {
                return null;
            }
            URITree child = lastChild.children.get(path);
            if (child == null) {
                child = lastChild.children.get("{}");
            }
            if (child == null) {
                child = lastChild.children.get("*");
                return child == null ? null : child.uri;
            }
            lastChild = child;
        }
        return lastChild.uri;
    }

    public String toString() {
        if (this.children == null) {
            return this.uri;
        }
        return this.children.toString();
    }
}

