/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.resources;

import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import java.util.Map;
import java.util.Set;

public class ActualContentTypeDetector {
    private final Set<String> needToDetectActualContentTypes = Sets.newHashSet((Object[])new String[]{"application/gzip"});
    private final Map<String, String> actualContentTypeByExtension = EzyMapBuilder.mapBuilder().put((Object)"wasm.gz", (Object)"application/wasm").toMap();
    private static final ActualContentTypeDetector INSTANCE = new ActualContentTypeDetector();

    private ActualContentTypeDetector() {
    }

    public static ActualContentTypeDetector getInstance() {
        return INSTANCE;
    }

    public String detect(String resourcePath, String originalContentType) {
        if (!this.needToDetectActualContentTypes.contains(originalContentType)) {
            return originalContentType;
        }
        String twoPartsExtension = this.extractTwoPartsExtension(resourcePath);
        return this.actualContentTypeByExtension.getOrDefault(twoPartsExtension, originalContentType);
    }

    private String extractTwoPartsExtension(String resourcePath) {
        int dotCount = 0;
        for (int i = resourcePath.length() - 1; i >= 0; --i) {
            char ch = resourcePath.charAt(i);
            if (ch == '.') {
                ++dotCount;
            }
            if (dotCount == 2) {
                return resourcePath.substring(i + 1);
            }
            if (ch == '/' || ch == '\\') break;
        }
        return "";
    }
}

