/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.support.reflect;

import com.tvd12.ezyfox.core.annotation.EzyTryCatch;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfoxserver.support.reflect.EzyExceptionHandlerMethod;
import java.util.ArrayList;
import java.util.List;

public class EzyExceptionHandlerProxy {
    protected final EzyClass clazz;
    protected final Object instance;
    protected final List<EzyExceptionHandlerMethod> exceptionHandlerMethods;

    public EzyExceptionHandlerProxy(Object instance) {
        this.instance = instance;
        this.clazz = new EzyClass(instance.getClass());
        this.exceptionHandlerMethods = this.fetchExceptionHandlerMethods();
    }

    public List<EzyExceptionHandlerMethod> fetchExceptionHandlerMethods() {
        ArrayList<EzyExceptionHandlerMethod> list = new ArrayList<EzyExceptionHandlerMethod>();
        List methods = this.clazz.getPublicMethods(m -> m.isAnnotated(EzyTryCatch.class));
        for (EzyMethod method : methods) {
            EzyExceptionHandlerMethod m2 = new EzyExceptionHandlerMethod(method);
            list.add(m2);
        }
        return list;
    }

    public String getClassSimpleName() {
        return this.clazz.getClazz().getSimpleName();
    }

    public String toString() {
        return this.clazz.getName() + "(\n\tinstance: " + this.instance + ",\n\texceptionHandlerMethods: " + this.exceptionHandlerMethods + "\n)";
    }

    public EzyClass getClazz() {
        return this.clazz;
    }

    public Object getInstance() {
        return this.instance;
    }

    public List<EzyExceptionHandlerMethod> getExceptionHandlerMethods() {
        return this.exceptionHandlerMethods;
    }
}

