/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminMediaControllerService;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAvatarRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateCoverImageRequest;
import org.youngmonkeys.ezyplatform.admin.response.AdminMediaDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.admin.validator.AdminMediaValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.request.UpdateMediaRequest;
import org.youngmonkeys.ezyplatform.response.MediaResponse;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiAdminMeMediaController {
    private final AdminAdminService adminService;
    private final AdminMediaControllerService mediaControllerService;
    private final AdminCommonValidator commonValidator;
    private final AdminMediaValidator mediaValidator;

    @DoPut(value="/me/media/{id}")
    public ResponseEntity mediaIdPut(@AdminId long adminId, @PathVariable(value="id") long mediaId, @RequestBody UpdateMediaRequest request) {
        this.mediaValidator.validateAdminMedia(adminId, mediaId);
        this.mediaControllerService.updateMedia(mediaId, request);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/me/media/{id}")
    public ResponseEntity mediaMediaIdDelete(@AdminId long adminId, @PathVariable(value="id") long mediaId) {
        this.mediaValidator.validateAdminMedia(adminId, mediaId);
        this.mediaControllerService.removeMedia(mediaId);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/admins/me/update-avatar")
    public ResponseEntity adminsMeUpdateAvatarPut(@AdminId long adminId, @RequestBody UpdateAvatarRequest request) {
        long avatarId = request.getAvatarId();
        this.commonValidator.validateId("avatarId", avatarId);
        this.adminService.updateAvatar(adminId, avatarId);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/admins/me/update-cover-image")
    public ResponseEntity adminsMeUpdateCoverImagePut(@AdminId long adminId, @RequestBody UpdateCoverImageRequest request) {
        long coverImageId = request.getCoverImageId();
        this.commonValidator.validateId("coverImageId", coverImageId);
        this.adminService.updateCoverImage(adminId, coverImageId);
        return ResponseEntity.noContent();
    }

    @Async
    @DoGet(value="/me/media/{name}")
    public void mediaNameGet(RequestArguments requestArguments, @AdminId long adminId, @PathVariable(value="name") String name) throws Exception {
        this.mediaValidator.validateAdminMedia(adminId, name);
        this.mediaControllerService.getMedia(requestArguments, name);
    }

    @DoGet(value="/me/media/{id}/details")
    public AdminMediaDetailsResponse mediaIdDetailsGet(@AdminId long adminId, @PathVariable long mediaId) throws Exception {
        this.mediaValidator.validateAdminMedia(adminId, mediaId);
        return this.mediaControllerService.getMediaDetailsResponse(mediaId);
    }

    @Async
    @DoGet(value="/me/media/{name}")
    public void meMediaNameGet(RequestArguments requestArguments, @AdminId long adminId, @PathVariable(value="name") String name) throws Exception {
        this.mediaValidator.validateAdminMedia(adminId, name);
        this.mediaControllerService.getMedia(requestArguments, name);
    }

    @DoGet(value="/me/media/list")
    public PaginationModel<MediaResponse> meMediaListGet(@AdminId long adminId, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        return this.mediaControllerService.getAdminMediaList(adminId, nextPageToken, prevPageToken, lastPage, limit);
    }

    public AdminApiAdminMeMediaController(AdminAdminService adminService, AdminMediaControllerService mediaControllerService, AdminCommonValidator commonValidator, AdminMediaValidator mediaValidator) {
        this.adminService = adminService;
        this.mediaControllerService = mediaControllerService;
        this.commonValidator = commonValidator;
        this.mediaValidator = mediaValidator;
    }
}

