/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminAdminControllerService;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminRequestToModelConverter;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminModel;
import org.youngmonkeys.ezyplatform.admin.model.AdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.pagination.AdminAdminFilter;
import org.youngmonkeys.ezyplatform.admin.request.AddAdminRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddAdminRoleNameRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddAdminRoleRequest;
import org.youngmonkeys.ezyplatform.admin.request.AllowAccessAllMediaRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveRoleFeaturesRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminRoleNameRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminRolesRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdatePasswordRequest;
import org.youngmonkeys.ezyplatform.admin.response.AddAdminResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminInfoResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminNameResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.response.AdminRoleResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminRoleFeatureService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSpecificMailService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminAdminsValidator;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.constant.AdminRoles;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.entity.AdminStatus;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminNameModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.util.CollectionFunctions;
import org.youngmonkeys.ezyplatform.util.Sha256Uuids;

@Api
@Authenticated
@Controller(value="/api/v1")
public class AdminApiAdminsController {
    private final FeatureURIManager featureUriManager;
    private final AdminAdminService adminService;
    private final AdminSettingService settingService;
    private final AdminAdminRoleService adminRoleService;
    private final AdminRoleFeatureService roleFeatureService;
    private final AdminSpecificMailService specificMailService;
    private final AdminAdminControllerService adminAdminControllerService;
    private final AdminCommonValidator commonValidator;
    private final AdminAdminsValidator adminsValidator;
    private final AdminRequestToModelConverter requestToModelConverter;
    private final AdminModelToResponseConverter modelToResponseConverter;

    @EzyFeature(value="admin_management")
    @DoGet(value="/admins")
    public PaginationModel<AdminInfoResponse> adminsGet(@RequestParam(value="ids") Set<Long> adminIds, @RequestParam(value="roleIds") Set<Long> roleIds, @RequestParam(value="roleNames") Set<String> roleNames, @RequestParam(value="keyword") String keyword, @RequestParam(value="adminStatus") AdminStatus adminStatus, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        this.commonValidator.validatePageSize(limit);
        this.adminsValidator.validateAdminRoleIds(roleIds);
        this.adminsValidator.validateAdminRoleNames(roleNames);
        AdminAdminFilter.Builder filterBuilder = (AdminAdminFilter.Builder)((AdminAdminFilter.Builder)((AdminAdminFilter.Builder)((AdminAdminFilter.Builder)AdminAdminFilter.builder().ids(CollectionFunctions.toNullIfEmpty(adminIds))).status(adminStatus)).roleIds(CollectionFunctions.toNullIfEmpty(roleIds))).roleNames(CollectionFunctions.toNullIfEmpty(roleNames));
        return this.adminAdminControllerService.getAdminInfoPagination(keyword, filterBuilder, nextPageToken, prevPageToken, lastPage, limit);
    }

    @EzyFeature(value="admin_management")
    @DoGet(value="/admins/simple-search")
    public List<AdminNameModel> adminsSimpleSearchGet(@RequestParam(value="roleIds") Set<Long> roleIds, @RequestParam(value="roleNames") Set<String> roleNames, @RequestParam(name="keyword") String keyword, @RequestParam(name="limit", defaultValue="25") int limit) {
        this.commonValidator.validatePageSize(limit);
        this.commonValidator.validateSearchKeyword(keyword);
        if (!roleIds.isEmpty()) {
            return this.adminService.simpleSearchWithRoleIds(roleIds, keyword, limit);
        }
        if (!roleNames.isEmpty()) {
            return this.adminService.simpleSearchWithRoleNames(roleNames, keyword, limit);
        }
        return this.adminService.simpleSearch(keyword, limit);
    }

    @EzyFeature(value="admin_management")
    @DoGet(value="/admins/{id}/name")
    public AdminNameResponse adminsIdNameGet(@PathVariable(value="id") long adminId) {
        AdminModel admin = this.adminsValidator.validateAdminId(adminId);
        return this.modelToResponseConverter.toNameResponse(admin);
    }

    @EzyFeature(value="admin_management")
    @DoPost(value="/admins/add")
    public AddAdminResponse adminsAddPost(@RequestBody AddAdminRequest request) {
        this.adminsValidator.validate(request);
        AddAdminModel addAdminModel = this.requestToModelConverter.toModel(request);
        AdminModel adminModel = this.adminService.addAdmin(addAdminModel);
        this.specificMailService.sendAddNewAdminMail(adminModel.getEmail(), adminModel.getName());
        return this.modelToResponseConverter.toAddResponse(adminModel);
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admins/me")
    public ResponseEntity adminsMePut(@AdminId long adminId, @RequestBody UpdateAdminRequest request) {
        this.adminsValidator.validate(adminId, request);
        this.adminService.updateAdmin(adminId, this.requestToModelConverter.toModel(request));
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admins/{username}")
    public ResponseEntity adminsUsernamePut(@AdminId long adminId, @PathVariable String username, @RequestBody UpdateAdminRequest request) {
        AdminModel admin = this.adminsValidator.validateAdminUsername(username);
        long updatedAdminId = admin.getId();
        this.adminsValidator.validate(updatedAdminId, request);
        this.adminService.updateAdmin(username, this.requestToModelConverter.toModel(request));
        if (updatedAdminId != adminId) {
            AdminModel updatedAdmin = this.adminService.getAdminById(updatedAdminId);
            this.specificMailService.sendUpdateAdminProfileMail(adminId, updatedAdmin.getEmail(), updatedAdmin.getName());
        }
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admins/me/roles")
    public ResponseEntity adminsMeRolesPut(@AdminId long adminId, @RequestBody UpdateAdminRolesRequest request) {
        this.adminsValidator.validate(adminId, request);
        this.adminRoleService.replaceAdminRoles(adminId, request.getRoleIds());
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admins/{username}/roles")
    public ResponseEntity adminsUsernameRolesPut(@AdminId long adminId, @PathVariable String username, @RequestBody UpdateAdminRolesRequest request) {
        AdminModel admin = this.adminsValidator.validateAdminUsername(username);
        this.adminsValidator.validate(adminId, request);
        long updatedAdminId = admin.getId();
        this.adminRoleService.replaceAdminRoles(updatedAdminId, request.getRoleIds());
        if (updatedAdminId != adminId) {
            AdminModel updatedAdmin = this.adminService.getAdminById(updatedAdminId);
            this.specificMailService.sendUpdateAdminRoles(adminId, updatedAdmin.getEmail(), updatedAdmin.getName());
        }
        return ResponseEntity.noContent();
    }

    @DoPut(value="/admins/me/update-password")
    public ResponseEntity adminsMeUpdatePasswordPut(@AdminId long adminId, @RequestBody UpdatePasswordRequest request) {
        this.commonValidator.validate(request);
        this.adminService.updatePassword(adminId, request.getOldPassword(), request.getNewPassword());
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admins/{username}/update-password")
    public ResponseEntity adminsUsernameUpdatePasswordPut(@AdminId long adminId, @PathVariable String username, @RequestBody UpdatePasswordRequest request) {
        this.adminsValidator.validateAdminUsername(username);
        this.commonValidator.validate(request);
        this.adminService.updatePassword(username, request.getOldPassword(), request.getNewPassword());
        AdminModel updatedAdmin = this.adminService.getAdminByUsername(username);
        this.specificMailService.sendUpdateAdminPasswordMail(adminId, updatedAdmin.getEmail(), updatedAdmin.getName());
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPost(value="/admins/{username}/request-reset-password")
    public ResponseEntity adminsUsernameRequestResetPasswordPut(@AdminId long adminId, @PathVariable String username) {
        this.adminsValidator.validateAdminUsername(username);
        long now = System.currentTimeMillis();
        long tokenExpiredInDay = this.settingService.getAdminResetPasswordTokenExpiredInDay();
        long tokenExpiredAt = now + tokenExpiredInDay * 24L * 60L * 60L * 1000L;
        AdminModel toAdmin = this.adminService.getAdminByUsername(username);
        String token = Sha256Uuids.generateUuid((String)username);
        this.adminService.createNewResetPasswordToken(toAdmin.getId(), token, tokenExpiredAt);
        this.specificMailService.sendResetAdminPasswordMail(adminId, toAdmin.getEmail(), toAdmin.getUsername(), toAdmin.getName(), token, tokenExpiredAt);
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admins/{username}/archive")
    public ResponseEntity adminsUsernameArchivePut(@PathVariable String username, @org.youngmonkeys.ezyplatform.annotation.AdminRoles AdminRolesProxy adminRoles) {
        this.adminsValidator.validateAdminUsername(username);
        this.adminService.archiveAdmin(username, adminRoles.isSuperAdmin());
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admins/{username}/activate")
    public ResponseEntity adminsUsernameActivatePut(@PathVariable String username) {
        this.adminsValidator.validateAdminUsername(username);
        this.adminService.activateAdmin(username);
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admins/{username}/allow-access-all-media")
    public ResponseEntity adminsUsernameAllowAccessAllMediaPut(@PathVariable String username, @RequestBody AllowAccessAllMediaRequest request) {
        AdminModel admin = this.adminsValidator.validateAdminUsername(username);
        this.adminService.setAllowAccessAllMedia(admin.getId(), request.isAllow());
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoGet(value="/admin/role-names")
    public List<AdminRoleNameModel> adminRoleNamesGet() {
        return this.adminRoleService.getAdminRoleNames();
    }

    @EzyFeature(value="admin_management")
    @DoPost(value="/admin/role-names/add")
    public AdminRoleNameModel adminRoleNamesAddPost(@AdminId long adminId, @RequestBody AddAdminRoleNameRequest request) {
        this.adminsValidator.validate(adminId, request);
        return this.adminRoleService.saveAdminRoleName(this.requestToModelConverter.toModel(request));
    }

    @EzyFeature(value="admin_management")
    @DoPut(value="/admin/role-names/{roleNameId}")
    public ResponseEntity adminRoleNamesRoleNamePost(@AdminId long adminId, @PathVariable long roleNameId, @RequestBody UpdateAdminRoleNameRequest request) {
        this.adminsValidator.validate(adminId, roleNameId, request);
        this.adminRoleService.saveAdminRoleName(this.requestToModelConverter.toModel(roleNameId, request));
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoDelete(value="/admin/role-names/{roleName}")
    public ResponseEntity adminRolesRoleNameDelete(@AdminId long adminId, @PathVariable String roleName) {
        AdminRoleNameModel role = this.adminsValidator.validateDeleteAdminRoleName(adminId, roleName);
        this.adminRoleService.deleteAdminRoleNameById(role.getId());
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoGet(value="/admin/roles")
    public List<AdminRoleResponse> adminRolesGet(@AdminId long adminId) {
        List<AdminRoleNameModel> roleNames = this.adminRoleService.getVisibleAdminRoleNamesByAdminId(adminId);
        List roleIds = EzyLists.newArrayList(roleNames, AdminRoleNameModel::getId);
        return this.modelToResponseConverter.toAdminRoleResponses(roleNames, this.adminRoleService.countRoleAdmins(roleIds));
    }

    @EzyFeature(value="admin_management")
    @DoGet(value="/admin/roles/{roleName}/members")
    public PaginationModel<AdminRoleMemberResponse> adminRolesRoleNameMembersGet(@AdminId long adminId, @PathVariable String roleName, @RequestParam(value="keyword") String keyword, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        this.adminsValidator.validateAdminRoleName(roleName);
        AdminRoleNameModel role = this.adminsValidator.validateAdminRolePriority(adminId, roleName);
        AdminAdminFilter.Builder filterBuilder = (AdminAdminFilter.Builder)AdminAdminFilter.builder().roleId(role.getId());
        return this.adminAdminControllerService.getAdminRoleMemberPagination(role.getId(), keyword, filterBuilder, nextPageToken, prevPageToken, lastPage, limit);
    }

    @EzyFeature(value="admin_management")
    @DoPost(value="/admin/roles/add")
    public ResponseEntity adminRolesAddPost(@AdminId long adminId, @RequestBody AddAdminRoleRequest request) {
        this.adminsValidator.validate(adminId, request);
        this.adminRoleService.saveAdminRole(this.requestToModelConverter.toModel(request));
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoDelete(value="/admin/roles/{roleId}/{adminId}")
    public ResponseEntity adminRolesRoleIdAdminId(@AdminId long byAdminId, @PathVariable(value="roleId") long roleId, @PathVariable(value="adminId") long adminId, @org.youngmonkeys.ezyplatform.annotation.AdminRoles AdminRolesProxy adminRoles) {
        this.adminsValidator.validateDeleteRoleIdAdminId(byAdminId, roleId, adminId, adminRoles);
        this.adminRoleService.deleteAdminRole(roleId, adminId);
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoPost(value="/admin/roles/{roleId}/features/save")
    public ResponseEntity adminRolesRoleIdFeaturesSavePost(@AdminId long adminId, @PathVariable(value="roleId") long roleId, @RequestBody SaveRoleFeaturesRequest request) {
        this.adminsValidator.validate(adminId, roleId, request);
        this.roleFeatureService.saveRoleFeatures(roleId, TargetType.ADMIN, request.getMethodsUriMapByFeature());
        return ResponseEntity.noContent();
    }

    @EzyFeature(value="admin_management")
    @DoGet(value="/admin/roles/{roleId}/features")
    public Map<String, Map<String, List<HttpMethod>>> adminRolesRoleIdFeaturesGet(@PathVariable long roleId) {
        AdminRoleNameModel role = this.adminsValidator.validateAdminRoleId(roleId);
        if (AdminRoles.UNMODIFIABLE_ROLE_NAMES.contains(role.getName())) {
            return this.featureUriManager.getURIsByFeatureMap();
        }
        return this.roleFeatureService.getMethodsUriMapOfFeatureByRoleId(roleId);
    }

    @EzyFeature(value="admin_management")
    @DoGet(value="/admin/features")
    public Map<String, Map<String, List<HttpMethod>>> adminFeaturesGet() {
        return this.featureUriManager.getURIsByFeatureMap();
    }

    public AdminApiAdminsController(FeatureURIManager featureUriManager, AdminAdminService adminService, AdminSettingService settingService, AdminAdminRoleService adminRoleService, AdminRoleFeatureService roleFeatureService, AdminSpecificMailService specificMailService, AdminAdminControllerService adminAdminControllerService, AdminCommonValidator commonValidator, AdminAdminsValidator adminsValidator, AdminRequestToModelConverter requestToModelConverter, AdminModelToResponseConverter modelToResponseConverter) {
        this.featureUriManager = featureUriManager;
        this.adminService = adminService;
        this.settingService = settingService;
        this.adminRoleService = adminRoleService;
        this.roleFeatureService = roleFeatureService;
        this.specificMailService = specificMailService;
        this.adminAdminControllerService = adminAdminControllerService;
        this.commonValidator = commonValidator;
        this.adminsValidator = adminsValidator;
        this.requestToModelConverter = requestToModelConverter;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

