/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.response.AdminMediaDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.model.MediaDetailsModel;

@EzySingleton
public class AdminMediaModelDecorator {
    private final AdminAdminService adminService;
    private final AdminUserService userService;
    private final AdminModelToResponseConverter modelToResponseConverter;

    public AdminMediaDetailsResponse decorate(MediaDetailsModel model) {
        long ownerAdminId = model.getOwnerAdminId();
        long ownerUserId = model.getOwnerUserId();
        return this.modelToResponseConverter.toResponse(model, ownerAdminId <= 0L ? null : this.adminService.getAdminNameById(ownerAdminId), ownerUserId <= 0L ? null : this.userService.getUsernameById(ownerUserId));
    }

    public AdminMediaModelDecorator(AdminAdminService adminService, AdminUserService userService, AdminModelToResponseConverter modelToResponseConverter) {
        this.adminService = adminService;
        this.userService = userService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

