/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.jdbc;

import com.tvd12.ezyfox.annotation.EzyProperty;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.stream.EzyAnywayInputStreamLoader;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import org.youngmonkeys.ezyplatform.util.Strings;

@EzySingleton
public class AdminJdbcProxy
extends EzyLoggable {
    @EzyProperty(value="datasource.driver_class_name")
    private String driverClassName;
    @EzyProperty(value="datasource.jdbc_url")
    private String jdbcUrl;
    @EzyProperty(value="datasource.username")
    private String username;
    @EzyProperty(value="datasource.password")
    private String password;
    @EzyProperty(value="tables.create_manually")
    private boolean createTablesManually;
    private static final String[] COMMENT_PREFIXES = new String[]{"/*", "*/", "*", "--", "#"};

    public boolean runScriptFile(Connection connection, String scriptFile) throws Exception {
        if (this.createTablesManually) {
            return false;
        }
        this.runScript(scriptFile, connection, this.readScriptFile(scriptFile));
        return true;
    }

    private void runScript(String scriptFile, Connection connection, String script) throws Exception {
        String[] fragments;
        for (String fragment : fragments = script.split(";")) {
            if (!EzyStrings.isNotBlank((String)fragment)) continue;
            try (Statement statement = connection.createStatement();){
                statement.execute(fragment);
            }
            catch (Throwable e) {
                String fileName = new File(scriptFile).getName();
                if (fileName.contains("alter")) {
                    this.logger.info("can not run script fragment: {} in file: {} cause by: {} ({})", new Object[]{fragment, scriptFile, e.getClass(), e.getMessage()});
                    continue;
                }
                throw e;
            }
        }
    }

    public Connection createConnection() throws Exception {
        if (EzyStrings.isNoContent((String)this.driverClassName) || EzyStrings.isNoContent((String)this.jdbcUrl)) {
            throw new IllegalStateException("did not setup server");
        }
        Class.forName(this.driverClassName);
        return EzyStrings.isNoContent((String)this.username) || EzyStrings.isNoContent((String)this.password) ? DriverManager.getConnection(this.jdbcUrl) : DriverManager.getConnection(this.jdbcUrl, this.username, this.password);
    }

    private String readScriptFile(String scriptFile) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(EzyAnywayInputStreamLoader.builder().context(((Object)((Object)this)).getClass()).build().load(scriptFile)));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                boolean isValid = true;
                for (String commentPrefix : COMMENT_PREFIXES) {
                    if (!Strings.startsWithIgnoreSpaces((String)line, (String)commentPrefix)) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) continue;
                lines.add(line);
            }
            String string = String.join((CharSequence)"\n", lines);
            return string;
        }
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCreateTablesManually(boolean createTablesManually) {
        this.createTablesManually = createTablesManually;
    }
}

