/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.pipeline;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.youngmonkeys.ezyplatform.admin.pipeline.AdminDataPipelineWorker;
import org.youngmonkeys.ezyplatform.concurrent.DefaultThreadFactory;

public class AdminDataPipeline
extends EzyLoggable {
    private final EzySingletonFactory singletonFactory;
    private final Map<String, AdminDataPipelineWorker> workerByName = new ConcurrentHashMap<String, AdminDataPipelineWorker>();
    private final Map<String, AtomicBoolean> needResetByWorkerName = new ConcurrentHashMap<String, AtomicBoolean>();
    private static final int MAX_SLEEP_TIME = 300;

    public void start() {
        this.singletonFactory.getSingletonsOf(AdminDataPipelineWorker.class).forEach(worker -> this.workerByName.put(worker.getClass().getName(), (AdminDataPipelineWorker)worker));
        DefaultThreadFactory threadFactory = DefaultThreadFactory.create((String)"data-pipeline");
        Thread newThread = threadFactory.newThread(this::loop);
        newThread.start();
    }

    public void reset(String workerName) {
        if (this.workerByName.containsKey(workerName)) {
            this.needResetByWorkerName.put(workerName, new AtomicBoolean(true));
        }
    }

    private void loop() {
        while (true) {
            long startTime = System.currentTimeMillis();
            for (String workerName : this.workerByName.keySet()) {
                AdminDataPipelineWorker worker = this.workerByName.get(workerName);
                this.needResetByWorkerName.computeIfPresent(workerName, (k, v) -> {
                    if (v.get()) {
                        v.set(false);
                        worker.reset();
                    }
                    return v;
                });
                try {
                    worker.run();
                }
                catch (Exception e) {
                    this.logger.info("worker: {} error", (Object)worker, (Object)e);
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            long remainSleepTime = 300L - elapsedTime;
            if (remainSleepTime <= 0L) continue;
            try {
                Thread.sleep(remainSleepTime);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public List<AdminDataPipelineWorker> getWorkers() {
        return new ArrayList<AdminDataPipelineWorker>(this.workerByName.values());
    }

    public AdminDataPipeline(EzySingletonFactory singletonFactory) {
        this.singletonFactory = singletonFactory;
    }
}

