/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.util.Next;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import com.tvd12.properties.file.reader.FileReader;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminResultToModelConverter;
import org.youngmonkeys.ezyplatform.admin.model.AddContentTemplateModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateContentTemplateModel;
import org.youngmonkeys.ezyplatform.admin.repo.AdminContentTemplateRepository;
import org.youngmonkeys.ezyplatform.admin.result.TemplateTypeResult;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.entity.ContentTemplate;
import org.youngmonkeys.ezyplatform.entity.ContentTemplateStatus;
import org.youngmonkeys.ezyplatform.model.ContentTemplateModel;
import org.youngmonkeys.ezyplatform.repo.ContentTemplateRepository;
import org.youngmonkeys.ezyplatform.service.DefaultContentTemplateService;

@Service
public class AdminContentTemplateService
extends DefaultContentTemplateService {
    private final FileReader propertiesFileReader;
    private final AdminContentTemplateRepository contentTemplateRepository;
    private final AdminModelToEntityConverter modelToEntityConverter;
    private final AdminResultToModelConverter resultToModelConverter;

    public AdminContentTemplateService(FileReader propertiesFileReader, AdminContentTemplateRepository contentTemplateRepository, AdminModelToEntityConverter modelToEntityConverter, AdminEntityToModelConverter entityToModelConverter, AdminResultToModelConverter resultToModelConverter) {
        super((ContentTemplateRepository)contentTemplateRepository, (DefaultEntityToModelConverter)entityToModelConverter);
        this.propertiesFileReader = propertiesFileReader;
        this.contentTemplateRepository = contentTemplateRepository;
        this.modelToEntityConverter = modelToEntityConverter;
        this.resultToModelConverter = resultToModelConverter;
    }

    public long addTemplate(long adminId, String templateType, AddContentTemplateModel model) {
        ContentTemplate entity = this.modelToEntityConverter.toEntity(adminId, templateType, model);
        this.contentTemplateRepository.save(entity);
        return entity.getId();
    }

    public long addTemplateIfAbsent(String templateType, String templateName, Supplier<AddContentTemplateModel> templateSupplier) {
        return this.addTemplateIfAbsent(0L, templateType, templateName, templateSupplier);
    }

    public long addTemplateIfAbsent(long adminId, String templateType, String templateName, Supplier<AddContentTemplateModel> templateSupplier) {
        ContentTemplate entity = this.contentTemplateRepository.findByTemplateTypeAndTemplateName(templateType, templateName);
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(adminId, templateType, templateSupplier.get());
            this.contentTemplateRepository.save(entity);
        }
        return entity.getId();
    }

    public long addTemplateIfAbsentFromPropertiesFile(String templateType, String templateName, String propertiesFilePath) {
        return this.addTemplateIfAbsentFromPropertiesFile(0L, templateType, templateName, propertiesFilePath);
    }

    public long addTemplateIfAbsentFromPropertiesFile(long adminId, String templateType, String templateName, String propertiesFilePath) {
        Properties properties = this.propertiesFileReader.read(propertiesFilePath);
        return this.addTemplateIfAbsent(adminId, templateType, templateName, () -> AddContentTemplateModel.builder().templateName(templateName).titleTemplate(properties.getProperty("title")).contentTemplate(properties.getProperty("content")).status(ContentTemplateStatus.COMPLETED.toString()).build());
    }

    public void saveTemplate(UpdateContentTemplateModel model) {
        ContentTemplate entity = (ContentTemplate)this.contentTemplateRepository.findById(model.getTemplateId());
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.contentTemplateRepository.save(entity);
    }

    public void deleteTemplate(long templateId) {
        this.contentTemplateRepository.delete(templateId);
    }

    public List<String> getAllTemplateTypes() {
        return EzyLists.newArrayList(this.contentTemplateRepository.findAllTemplateTypes(), TemplateTypeResult::getTemplateType);
    }

    public List<ContentTemplateModel> getTemplatesByType(String templateType, int limit) {
        return EzyLists.newArrayList(this.contentTemplateRepository.findTemplatesByType(templateType, Next.limit((long)limit)), this.resultToModelConverter::toModel);
    }

    public long countTemplatesByType(String templateType) {
        return this.contentTemplateRepository.countByTemplateType(templateType);
    }
}

