/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.EzyHttpServerBootstrap;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.api.EzyResponseApi;
import com.tvd12.ezyfoxserver.api.EzyResponseApiAware;
import com.tvd12.ezyfoxserver.api.EzyStreamingApi;
import com.tvd12.ezyfoxserver.api.EzyStreamingApiAware;
import com.tvd12.ezyfoxserver.nio.EzySocketServerBootstrap;
import com.tvd12.ezyfoxserver.nio.EzyUdpServerBootstrap;
import com.tvd12.ezyfoxserver.nio.EzyWebSocketServerBootstrap;
import com.tvd12.ezyfoxserver.nio.socket.EzySocketDataReceiver;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManager;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.setting.EzySocketSetting;
import com.tvd12.ezyfoxserver.setting.EzyStreamingSetting;
import com.tvd12.ezyfoxserver.setting.EzyUdpSetting;
import com.tvd12.ezyfoxserver.setting.EzyWebSocketSetting;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsRequestQueues;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroupFetcher;
import com.tvd12.ezyfoxserver.socket.EzySocketDataHandlerGroupRemover;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnectionHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnectionHandlingLoopHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnectionQueue;
import com.tvd12.ezyfoxserver.socket.EzySocketEventHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketEventLoopOneHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketExtensionRequestHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketExtensionRequestHandlingLoopHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketStreamHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketStreamHandlingLoopHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketStreamQueue;
import com.tvd12.ezyfoxserver.socket.EzySocketSystemRequestHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketSystemRequestHandlingLoopHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketUserRemovalHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketUserRemovalHandlingLoopHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketUserRemovalQueue;
import javax.net.ssl.SSLContext;

public class EzyNioServerBootstrap
extends EzyHttpServerBootstrap {
    private SSLContext sslContext;
    private EzyResponseApi responseApi;
    private EzyStreamingApi streamingApi;
    private EzySocketStreamQueue streamQueue;
    private EzySocketDataReceiver socketDataReceiver;
    private EzyHandlerGroupManager handlerGroupManager;
    private EzySessionTicketsQueue socketSessionTicketsQueue;
    private EzySessionTicketsRequestQueues socketSessionTicketsRequestQueues;
    private EzySessionTicketsQueue websocketSessionTicketsQueue;
    private EzySocketDisconnectionQueue socketDisconnectionQueue;
    private EzyUdpServerBootstrap udpServerBootstrap;
    private EzySocketServerBootstrap socketServerBootstrap;
    private EzyWebSocketServerBootstrap websocketServerBootstrap;
    private EzySocketEventLoopOneHandler systemRequestHandlingLoopHandler;
    private EzySocketEventLoopOneHandler extensionRequestHandlingLoopHandler;
    private EzySocketEventLoopOneHandler streamHandlingLoopHandler;
    private EzySocketEventLoopOneHandler socketDisconnectionHandlingLoopHandler;
    private EzySocketEventLoopOneHandler socketUserRemovalHandlingLoopHandler;

    protected void setupServer() {
        EzyServer server = this.getServer();
        ((EzyResponseApiAware)server).setResponseApi(this.responseApi);
        ((EzyStreamingApiAware)server).setStreamingApi(this.streamingApi);
    }

    protected void startOtherBootstraps(Runnable callback) throws Exception {
        this.startSocketServerBootstrap();
        this.startUdpServerBootstrap();
        this.startWebSocketServerBootstrap();
        this.startRequestHandlingLoopHandlers();
        this.startStreamHandlingLoopHandlers();
        this.startDisconnectionHandlingLoopHandlers();
        this.startUserRemovalHandlingLoopHandlers();
        callback.run();
    }

    private void startSocketServerBootstrap() throws Exception {
        EzySocketSetting socketSetting = this.getSocketSetting();
        if (!socketSetting.isActive()) {
            return;
        }
        this.logger.debug("starting tcp socket server bootstrap ....");
        this.socketServerBootstrap = this.newSocketServerBootstrap();
        this.socketServerBootstrap.start();
        this.logger.debug("tcp socket server bootstrap has started");
    }

    private void startUdpServerBootstrap() throws Exception {
        EzyUdpSetting udpSetting = this.getUdpSetting();
        if (!udpSetting.isActive()) {
            return;
        }
        this.logger.debug("starting udp socket server bootstrap ....");
        this.udpServerBootstrap = this.newUdpServerBootstrap();
        this.udpServerBootstrap.start();
        this.logger.debug("udp socket server bootstrap has started");
    }

    protected void startWebSocketServerBootstrap() throws Exception {
        EzyWebSocketSetting wsSetting = this.getWebSocketSetting();
        if (!wsSetting.isActive()) {
            return;
        }
        this.logger.debug("starting websocket server bootstrap ....");
        this.websocketServerBootstrap = this.newWebSocketServerBootstrap();
        this.websocketServerBootstrap.start();
        this.logger.debug("websocket server bootstrap has started");
    }

    private void startRequestHandlingLoopHandlers() throws Exception {
        this.systemRequestHandlingLoopHandler = this.newSystemRequestHandlingLoopHandler();
        this.extensionRequestHandlingLoopHandler = this.newExtensionRequestHandlingLoopHandler();
        this.systemRequestHandlingLoopHandler.start();
        this.extensionRequestHandlingLoopHandler.start();
    }

    private void startStreamHandlingLoopHandlers() throws Exception {
        EzySettings settings = this.getServerSettings();
        EzyStreamingSetting streamingSetting = settings.getStreaming();
        if (streamingSetting.isEnable()) {
            this.streamHandlingLoopHandler = this.newSocketStreamHandlingLoopHandler();
            this.streamHandlingLoopHandler.start();
        }
    }

    private void startDisconnectionHandlingLoopHandlers() throws Exception {
        this.socketDisconnectionHandlingLoopHandler = this.newSocketDisconnectionHandlingLoopHandler();
        this.socketDisconnectionHandlingLoopHandler.start();
    }

    private void startUserRemovalHandlingLoopHandlers() throws Exception {
        this.socketUserRemovalHandlingLoopHandler = this.newSocketUserRemovalHandlingLoopHandler();
        this.socketUserRemovalHandlingLoopHandler.start();
    }

    private EzySocketServerBootstrap newSocketServerBootstrap() {
        return ((EzySocketServerBootstrap.Builder)((EzySocketServerBootstrap.Builder)((EzySocketServerBootstrap.Builder)((EzySocketServerBootstrap.Builder)EzySocketServerBootstrap.builder().serverContext(this.context)).sslContext(this.sslContext).socketDataReceiver(this.socketDataReceiver)).handlerGroupManager(this.handlerGroupManager)).sessionTicketsQueue(this.socketSessionTicketsQueue)).build();
    }

    private EzyUdpServerBootstrap newUdpServerBootstrap() {
        return EzyUdpServerBootstrap.builder().serverContext(this.context).socketDataReceiver(this.socketDataReceiver).handlerGroupManager(this.handlerGroupManager).build();
    }

    private EzyWebSocketServerBootstrap newWebSocketServerBootstrap() {
        return ((EzyWebSocketServerBootstrap.Builder)((EzyWebSocketServerBootstrap.Builder)((EzyWebSocketServerBootstrap.Builder)((EzyWebSocketServerBootstrap.Builder)EzyWebSocketServerBootstrap.builder().serverContext(this.context)).sslContext(this.sslContext).socketDataReceiver(this.socketDataReceiver)).handlerGroupManager(this.handlerGroupManager)).sessionTicketsQueue(this.websocketSessionTicketsQueue)).build();
    }

    private EzySocketEventLoopOneHandler newSystemRequestHandlingLoopHandler() {
        EzySocketSystemRequestHandlingLoopHandler loopHandler = new EzySocketSystemRequestHandlingLoopHandler();
        loopHandler.setThreadPoolSize(this.getSystemRequestHandlerPoolSize());
        EzySocketSystemRequestHandler eventHandler = new EzySocketSystemRequestHandler();
        eventHandler.setDataHandlerGroupFetcher((EzySocketDataHandlerGroupFetcher)this.handlerGroupManager);
        eventHandler.setSessionTicketsQueue(this.socketSessionTicketsRequestQueues.getSystemQueue());
        loopHandler.setEventHandler((EzySocketEventHandler)eventHandler);
        return loopHandler;
    }

    private EzySocketEventLoopOneHandler newExtensionRequestHandlingLoopHandler() {
        EzySocketExtensionRequestHandlingLoopHandler loopHandler = new EzySocketExtensionRequestHandlingLoopHandler();
        loopHandler.setThreadPoolSize(this.getExtensionRequestHandlerPoolSize());
        EzySocketExtensionRequestHandler eventHandler = new EzySocketExtensionRequestHandler();
        eventHandler.setDataHandlerGroupFetcher((EzySocketDataHandlerGroupFetcher)this.handlerGroupManager);
        eventHandler.setSessionTicketsQueue(this.socketSessionTicketsRequestQueues.getExtensionQueue());
        loopHandler.setEventHandler((EzySocketEventHandler)eventHandler);
        return loopHandler;
    }

    private EzySocketEventLoopOneHandler newSocketStreamHandlingLoopHandler() {
        EzySocketStreamHandlingLoopHandler loopHandler = new EzySocketStreamHandlingLoopHandler();
        loopHandler.setThreadPoolSize(this.getStreamHandlerPoolSize());
        EzySocketStreamHandler eventHandler = new EzySocketStreamHandler();
        eventHandler.setStreamQueue(this.streamQueue);
        eventHandler.setDataHandlerGroupFetcher((EzySocketDataHandlerGroupFetcher)this.handlerGroupManager);
        loopHandler.setEventHandler((EzySocketEventHandler)eventHandler);
        return loopHandler;
    }

    private EzySocketEventLoopOneHandler newSocketDisconnectionHandlingLoopHandler() {
        EzySocketDisconnectionHandlingLoopHandler loopHandler = new EzySocketDisconnectionHandlingLoopHandler();
        loopHandler.setThreadPoolSize(this.getSocketDisconnectionHandlerPoolSize());
        EzySocketDisconnectionHandler eventHandler = new EzySocketDisconnectionHandler();
        eventHandler.setDataHandlerGroupRemover((EzySocketDataHandlerGroupRemover)this.handlerGroupManager);
        eventHandler.setDisconnectionQueue(this.socketDisconnectionQueue);
        loopHandler.setEventHandler((EzySocketEventHandler)eventHandler);
        return loopHandler;
    }

    private EzySocketEventLoopOneHandler newSocketUserRemovalHandlingLoopHandler() {
        EzySocketUserRemovalHandlingLoopHandler loopHandler = new EzySocketUserRemovalHandlingLoopHandler();
        loopHandler.setThreadPoolSize(this.getSocketUserRemovalHandlerPoolSize());
        EzySocketUserRemovalQueue userRemovalQueue = (EzySocketUserRemovalQueue)this.context.get(EzySocketUserRemovalQueue.class);
        EzySocketUserRemovalHandler eventHandler = new EzySocketUserRemovalHandler(userRemovalQueue);
        loopHandler.setEventHandler((EzySocketEventHandler)eventHandler);
        return loopHandler;
    }

    private int getStreamHandlerPoolSize() {
        return this.getThreadPoolSizeSetting().getStreamHandler();
    }

    private int getSystemRequestHandlerPoolSize() {
        return this.getThreadPoolSizeSetting().getSystemRequestHandler();
    }

    private int getExtensionRequestHandlerPoolSize() {
        return this.getThreadPoolSizeSetting().getExtensionRequestHandler();
    }

    private int getSocketDisconnectionHandlerPoolSize() {
        return this.getThreadPoolSizeSetting().getSocketDisconnectionHandler();
    }

    private int getSocketUserRemovalHandlerPoolSize() {
        return this.getThreadPoolSizeSetting().getSocketUserRemovalHandler();
    }

    public void destroy() {
        super.destroy();
        if (this.socketServerBootstrap != null) {
            EzyProcessor.processWithLogException(this.socketServerBootstrap::destroy);
        }
        if (this.websocketServerBootstrap != null) {
            EzyProcessor.processWithLogException(this.websocketServerBootstrap::destroy);
        }
        if (this.udpServerBootstrap != null) {
            EzyProcessor.processWithLogException(this.udpServerBootstrap::destroy);
        }
        if (this.socketDataReceiver != null) {
            EzyProcessor.processWithLogException(this.socketDataReceiver::destroy);
        }
        if (this.handlerGroupManager != null) {
            EzyProcessor.processWithLogException(() -> ((EzyHandlerGroupManager)this.handlerGroupManager).destroy());
        }
        if (this.streamHandlingLoopHandler != null) {
            EzyProcessor.processWithLogException(() -> ((EzySocketEventLoopOneHandler)this.streamHandlingLoopHandler).destroy());
        }
        if (this.systemRequestHandlingLoopHandler != null) {
            EzyProcessor.processWithLogException(() -> ((EzySocketEventLoopOneHandler)this.systemRequestHandlingLoopHandler).destroy());
        }
        if (this.extensionRequestHandlingLoopHandler != null) {
            EzyProcessor.processWithLogException(() -> ((EzySocketEventLoopOneHandler)this.extensionRequestHandlingLoopHandler).destroy());
        }
        if (this.socketDisconnectionHandlingLoopHandler != null) {
            EzyProcessor.processWithLogException(() -> ((EzySocketEventLoopOneHandler)this.socketDisconnectionHandlingLoopHandler).destroy());
        }
        if (this.socketUserRemovalHandlingLoopHandler != null) {
            EzyProcessor.processWithLogException(() -> ((EzySocketEventLoopOneHandler)this.socketUserRemovalHandlingLoopHandler).destroy());
        }
        this.socketServerBootstrap = null;
        this.websocketServerBootstrap = null;
        this.socketDataReceiver = null;
        this.handlerGroupManager = null;
        this.streamHandlingLoopHandler = null;
        this.systemRequestHandlingLoopHandler = null;
        this.extensionRequestHandlingLoopHandler = null;
        this.socketDisconnectionHandlingLoopHandler = null;
        this.socketUserRemovalHandlingLoopHandler = null;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setResponseApi(EzyResponseApi responseApi) {
        this.responseApi = responseApi;
    }

    public void setStreamingApi(EzyStreamingApi streamingApi) {
        this.streamingApi = streamingApi;
    }

    public void setStreamQueue(EzySocketStreamQueue streamQueue) {
        this.streamQueue = streamQueue;
    }

    public void setSocketDataReceiver(EzySocketDataReceiver socketDataReceiver) {
        this.socketDataReceiver = socketDataReceiver;
    }

    public void setHandlerGroupManager(EzyHandlerGroupManager handlerGroupManager) {
        this.handlerGroupManager = handlerGroupManager;
    }

    public void setSocketSessionTicketsQueue(EzySessionTicketsQueue socketSessionTicketsQueue) {
        this.socketSessionTicketsQueue = socketSessionTicketsQueue;
    }

    public void setSocketSessionTicketsRequestQueues(EzySessionTicketsRequestQueues socketSessionTicketsRequestQueues) {
        this.socketSessionTicketsRequestQueues = socketSessionTicketsRequestQueues;
    }

    public void setWebsocketSessionTicketsQueue(EzySessionTicketsQueue websocketSessionTicketsQueue) {
        this.websocketSessionTicketsQueue = websocketSessionTicketsQueue;
    }

    public void setSocketDisconnectionQueue(EzySocketDisconnectionQueue socketDisconnectionQueue) {
        this.socketDisconnectionQueue = socketDisconnectionQueue;
    }
}

