/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller;

import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.handler.UnhandledErrorHandler;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.youngmonkeys.ezyplatform.manager.EnvironmentManager;
import org.youngmonkeys.ezyplatform.util.HttpRequests;

public class WebGlobalErrorHandler
implements UnhandledErrorHandler {
    @EzyAutoBind
    protected RequestURIManager requestUriManager;
    @EzyAutoBind
    protected EnvironmentManager environmentManager;

    public Object processError(HttpMethod method, HttpServletRequest request, HttpServletResponse response, int errorStatusCode, Exception exception) {
        boolean isApiUri;
        String matchedUri = (String)request.getAttribute("ezyAttributeMatchedURI");
        if (matchedUri == null) {
            matchedUri = request.getRequestURI();
        }
        boolean bl = isApiUri = method != HttpMethod.GET || this.requestUriManager.isApiURI(method, matchedUri);
        if (isApiUri) {
            return this.toResponseEntity(errorStatusCode, exception);
        }
        return this.postProcessError(method, request, response, errorStatusCode, exception);
    }

    protected Object processError(HttpServletRequest request, int errorStatusCode, Exception exception) {
        if (this.environmentManager.isDebugMode()) {
            return this.toResponseEntity(errorStatusCode, exception);
        }
        if (errorStatusCode == 406) {
            return ResponseEntity.status((int)406).build();
        }
        if (errorStatusCode == 500) {
            return Redirect.builder().uri(HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/server-error")).addAttribute("exceptionMessage", (Object)EzyStrings.exceptionToSimpleString((Throwable)exception)).build();
        }
        if (errorStatusCode == 400) {
            return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/not-found"));
    }

    protected Object postProcessError(HttpMethod method, HttpServletRequest request, HttpServletResponse response, int errorStatusCode, Exception exception) {
        return this.processError(request, errorStatusCode, exception);
    }

    private ResponseEntity toResponseEntity(int errorStatusCode, Exception exception) {
        return ResponseEntity.status((int)errorStatusCode).body(Collections.singletonMap("error", exception != null ? exception.getClass().getName() : String.valueOf(errorStatusCode))).build();
    }

    public void setRequestUriManager(RequestURIManager requestUriManager) {
        this.requestUriManager = requestUriManager;
    }

    public void setEnvironmentManager(EnvironmentManager environmentManager) {
        this.environmentManager = environmentManager;
    }
}

