/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.view;

import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyhttp.server.core.view.View;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.youngmonkeys.ezyplatform.web.view.WebViewLanguageDecorator;

public abstract class WebViewMessageDecorator
extends WebViewLanguageDecorator {
    @EzyAutoBind
    private EzySingletonFactory singletonFactory;
    private final Collection<String> messageKeys;
    private final AtomicReference<ViewContext> viewContextRef = new AtomicReference();

    public WebViewMessageDecorator() {
        this.messageKeys = this.messageKeys();
    }

    @Override
    public void decorate(HttpServletRequest request, View view) {
        super.decorate(request, view);
        ViewContext viewContext = this.getViewContext();
        view.putKeyValuesToVariable("additionalMessageMap", viewContext.resolveMessages(view.getLocale(), this.messageKeys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ViewContext getViewContext() {
        ViewContext viewContext = this.viewContextRef.get();
        if (viewContext == null) {
            AtomicReference<ViewContext> atomicReference = this.viewContextRef;
            synchronized (atomicReference) {
                viewContext = this.viewContextRef.get();
                if (viewContext == null) {
                    viewContext = (ViewContext)this.singletonFactory.getSingletonCast(ViewContext.class);
                    this.viewContextRef.set(viewContext);
                }
            }
        }
        return viewContext;
    }

    protected abstract Collection<String> messageKeys();

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void setSingletonFactory(EzySingletonFactory singletonFactory) {
        this.singletonFactory = singletonFactory;
    }
}

