/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.view;

import com.tvd12.ezyfox.bean.EzyPropertyFetcher;
import com.tvd12.ezyfox.builder.EzyBuilder;

public class TemplateResolver {
    private final String prefix;
    private final String suffix;
    private final int cacheTTLMs;
    private final boolean cacheable;
    private final String templateMode;
    private final String messagesLocation;

    protected TemplateResolver(Builder builder) {
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.cacheTTLMs = builder.cacheTTLMs;
        this.cacheable = builder.cacheable;
        this.templateMode = builder.templateMode;
        this.messagesLocation = builder.messagesLocation;
    }

    public static TemplateResolver of(EzyPropertyFetcher propertyFetcher) {
        return TemplateResolver.builder().setFrom(propertyFetcher).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getCacheTTLMs() {
        return this.cacheTTLMs;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public String getTemplateMode() {
        return this.templateMode;
    }

    public String getMessagesLocation() {
        return this.messagesLocation;
    }

    public static class Builder
    implements EzyBuilder<TemplateResolver> {
        private String prefix = "templates/";
        private String suffix = ".html";
        private int cacheTTLMs = 3600000;
        private boolean cacheable = true;
        private String templateMode = "HTML";
        private String messagesLocation = "messages";

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder cacheTTLMs(int cacheTTLMs) {
            this.cacheTTLMs = cacheTTLMs;
            return this;
        }

        public Builder cacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public Builder templateMode(String templateMode) {
            this.templateMode = templateMode;
            return this;
        }

        public Builder messagesLocation(String messagesLocation) {
            this.messagesLocation = messagesLocation;
            return this;
        }

        public Builder setFrom(EzyPropertyFetcher propertyFetcher) {
            this.templateMode = (String)propertyFetcher.getProperty((Object)"view.template.mode", String.class, (Object)this.templateMode);
            this.prefix = (String)propertyFetcher.getProperty((Object)"view.template.prefix", String.class, (Object)this.prefix);
            this.suffix = (String)propertyFetcher.getProperty((Object)"view.template.suffix", String.class, (Object)this.suffix);
            this.cacheTTLMs = (Integer)propertyFetcher.getProperty((Object)"view.template.cache_ttl_ms", Integer.TYPE, (Object)this.cacheTTLMs);
            this.cacheable = (Boolean)propertyFetcher.getProperty((Object)"view.template.cacheable", Boolean.TYPE, (Object)this.cacheable);
            this.messagesLocation = (String)propertyFetcher.getProperty((Object)"view.template.messages_location", String.class, (Object)this.messagesLocation);
            return this;
        }

        public TemplateResolver build() {
            return new TemplateResolver(this);
        }
    }
}

