/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.reflect.EzyInterfaces;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class EzyGenerics {
    private EzyGenerics() {
    }

    public static Class getOneGenericClassArgument(Type genericType) {
        return EzyGenerics.getGenericClassArguments(genericType, 1)[0];
    }

    public static Class[] getTwoGenericClassArguments(Type genericType) {
        return EzyGenerics.getGenericClassArguments(genericType, 2);
    }

    public static Class[] getGenericClassArguments(Type genericType, int size) {
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("1: " + genericType.getTypeName() + " is not generic type");
        }
        ArrayList<Class> answer = new ArrayList<Class>();
        Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
        if (types.length != size) {
            throw new IllegalArgumentException("2: " + genericType.getTypeName() + " has != " + size + " generic argument");
        }
        for (Type type : types) {
            if (type instanceof Class) {
                answer.add((Class)type);
                continue;
            }
            if (type instanceof ParameterizedType) {
                answer.add((Class)((ParameterizedType)type).getRawType());
                continue;
            }
            throw new IllegalArgumentException("3: unknown generic argument type of " + genericType.getTypeName());
        }
        return answer.toArray(new Class[0]);
    }

    public static Class[] getGenericInterfacesArguments(Class<?> clazz, Class<?> interfaceClass, int size) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(genericInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericInterface).getRawType().equals(interfaceClass)) continue;
            Type[] genericTypes = parameterizedType.getActualTypeArguments();
            if (genericTypes.length != size) {
                throw new IllegalArgumentException("1:" + genericInterface.getTypeName() + " has != " + size + " generic argument");
            }
            ArrayList<Class> answer = new ArrayList<Class>();
            for (Type genericType : genericTypes) {
                if (genericType instanceof Class) {
                    answer.add((Class)genericType);
                    continue;
                }
                if (genericType instanceof ParameterizedType) {
                    answer.add((Class)((ParameterizedType)genericType).getRawType());
                    continue;
                }
                throw new IllegalArgumentException("2: unknown generic argument type of " + genericType.getTypeName());
            }
            return answer.toArray(new Class[0]);
        }
        if (EzyInterfaces.getInterface(clazz, interfaceClass) != null) {
            throw new IllegalArgumentException("3: " + interfaceClass + " is not generics");
        }
        throw new IllegalArgumentException("4: " + clazz + " is not directly extends/implements " + interfaceClass);
    }
}

