/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.manager;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.gamebox.entity.Room;
import com.tvd12.gamebox.exception.MaxRoomException;
import com.tvd12.gamebox.exception.RoomExistsException;
import com.tvd12.gamebox.manager.RoomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractRoomManager<R extends Room>
implements RoomManager<R> {
    protected final int maxRoom;
    protected final Map<Long, R> roomById = this.newRoomByIdMap();
    protected final Map<String, R> roomByName = this.newRoomByNameMap();

    public AbstractRoomManager() {
        this(10000);
    }

    public AbstractRoomManager(int maxRoom) {
        this.maxRoom = maxRoom;
    }

    protected AbstractRoomManager(Builder<?, ?> builder) {
        this(builder.maxRoom);
    }

    @Override
    public void addRoom(R room, boolean failIfAdded) {
        int roomCount = this.roomByName.size();
        if (roomCount >= this.maxRoom) {
            throw new MaxRoomException(((Room)room).toString(), roomCount, this.maxRoom);
        }
        String roomName = ((Room)room).getName();
        boolean exists = this.roomByName.containsKey(roomName);
        if (exists && failIfAdded) {
            throw new RoomExistsException(roomName);
        }
        this.roomById.put(((Room)room).getId(), room);
        this.roomByName.put(roomName, room);
    }

    @Override
    public void addRooms(R[] rooms, boolean failIfAdded) {
        this.addRooms(Arrays.asList(rooms), failIfAdded);
    }

    @Override
    public void addRooms(Iterable<R> rooms, boolean failIfAdded) {
        int roomCount;
        int nextRoomCount;
        int count = 0;
        if (failIfAdded) {
            for (Room room : rooms) {
                if (this.roomByName.containsKey(room.getName())) {
                    throw new RoomExistsException(room.getName());
                }
                ++count;
            }
        }
        if ((nextRoomCount = (roomCount = this.roomByName.size()) + count) > this.maxRoom) {
            throw new MaxRoomException(count, roomCount, this.maxRoom);
        }
        for (Room room : rooms) {
            this.roomById.put(room.getId(), room);
            this.roomByName.put(room.getName(), room);
        }
    }

    @Override
    public boolean containsRoom(long id) {
        return this.roomById.containsKey(id);
    }

    @Override
    public boolean containsRoom(String name) {
        return this.roomByName.containsKey(name);
    }

    @Override
    public R getRoom(long id) {
        return (R)((Room)this.roomById.get(id));
    }

    @Override
    public R getRoom(String name) {
        return (R)((Room)this.roomByName.get(name));
    }

    @Override
    public R getRoom(Predicate<R> predicate) {
        for (Room room : this.roomByName.values()) {
            if (!predicate.test(room)) continue;
            return (R)room;
        }
        return null;
    }

    @Override
    public List<R> getRoomList() {
        return new ArrayList<R>(this.roomByName.values());
    }

    @Override
    public List<R> getRoomList(Predicate<R> predicate) {
        return this.roomByName.values().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public void getRoomList(List<R> buffer) {
        buffer.addAll(this.roomByName.values());
    }

    @Override
    public int getRoomCount() {
        return this.roomByName.size();
    }

    @Override
    public void removeRoom(R room) {
        this.doRemoveRoom(room);
    }

    @Override
    public void removeRoom(long id) {
        this.doRemoveRoom((Room)this.roomById.get(id));
    }

    @Override
    public void removeRoom(String name) {
        this.doRemoveRoom((Room)this.roomByName.get(name));
    }

    @Override
    public void removeRooms(Iterable<R> rooms) {
        for (Room room : rooms) {
            this.doRemoveRoom(room);
        }
    }

    protected void doRemoveRoom(R room) {
        if (room != null) {
            this.roomById.remove(((Room)room).getId());
            this.roomByName.remove(((Room)room).getName());
        }
    }

    @Override
    public boolean available() {
        return this.roomById.size() < this.maxRoom;
    }

    public void clear() {
        this.roomById.clear();
        this.roomByName.clear();
    }

    protected Map<Long, R> newRoomByIdMap() {
        return new ConcurrentHashMap();
    }

    protected Map<String, R> newRoomByNameMap() {
        return new ConcurrentHashMap();
    }

    public String toString() {
        return "roomByName.size = " + this.roomByName.size() + ", roomById.size = " + this.roomById.size();
    }

    @Override
    public int getMaxRoom() {
        return this.maxRoom;
    }

    public static abstract class Builder<R extends Room, B extends Builder<R, B>>
    implements EzyBuilder<RoomManager<R>> {
        protected int maxRoom = 10000;

        public B maxRoom(int maxRoom) {
            this.maxRoom = maxRoom;
            return (B)this;
        }
    }
}

