/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller.api;

import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.response.CountResponse;
import org.youngmonkeys.ezyplatform.web.annotation.UserId;
import org.youngmonkeys.ezyplatform.web.controller.service.WebNotificationControllerService;
import org.youngmonkeys.ezyplatform.web.response.NotificationResponse;
import org.youngmonkeys.ezyplatform.web.service.WebNotificationService;
import org.youngmonkeys.ezyplatform.web.validator.WebCommonValidator;

public class WebApiNotificationController {
    private final WebNotificationService webNotificationService;
    private final WebNotificationControllerService notificationControllerService;
    private final WebCommonValidator commonValidator;

    @DoGet(value="/account/notifications/count")
    public CountResponse accountNotificationsCountGet(@UserId long userId) {
        return new CountResponse(this.webNotificationService.countUserUnreadNotifications(userId));
    }

    @DoGet(value="/account/notifications")
    public PaginationModel<NotificationResponse> accountNotificationsGet(@UserId long userId, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="5") int limit) {
        this.commonValidator.validatePageSize(limit);
        return this.notificationControllerService.getUserNotifications(userId, nextPageToken, prevPageToken, lastPage, limit);
    }

    @DoPost(value="/account/notifications/{id}/read")
    public ResponseEntity accountNotificationsIdReadPost(@UserId long userId, @PathVariable long notificationId) {
        this.webNotificationService.updateUserNotificationByRead(userId, notificationId);
        return ResponseEntity.noContent();
    }

    @DoPost(value="/account/notifications/read")
    public ResponseEntity accountNotificationsReadPost(@UserId long userId) {
        this.webNotificationService.updateAllUserNotificationsByRead(userId);
        return ResponseEntity.noContent();
    }

    public WebApiNotificationController(WebNotificationService webNotificationService, WebNotificationControllerService notificationControllerService, WebCommonValidator commonValidator) {
        this.webNotificationService = webNotificationService;
        this.notificationControllerService = notificationControllerService;
        this.commonValidator = commonValidator;
    }
}

