/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.builder.impl;

import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfoxserver.EzyServerBootstrap;
import com.tvd12.ezyfoxserver.api.EzyProxyResponseApi;
import com.tvd12.ezyfoxserver.api.EzyProxyStreamingApi;
import com.tvd12.ezyfoxserver.api.EzyResponseApi;
import com.tvd12.ezyfoxserver.api.EzySecureProxyResponseApi;
import com.tvd12.ezyfoxserver.api.EzyStreamingApi;
import com.tvd12.ezyfoxserver.builder.EzyHttpServerBootstrapBuilder;
import com.tvd12.ezyfoxserver.codec.EzyCodecFactory;
import com.tvd12.ezyfoxserver.codec.EzySimpleCodecFactory;
import com.tvd12.ezyfoxserver.nio.EzyNioServerBootstrap;
import com.tvd12.ezyfoxserver.nio.builder.EzyNioServerBootstrapBuilder;
import com.tvd12.ezyfoxserver.nio.builder.impl.EzyHandlerGroupBuilderFactoryImpl;
import com.tvd12.ezyfoxserver.nio.factory.EzyHandlerGroupBuilderFactory;
import com.tvd12.ezyfoxserver.nio.socket.EzySecureSocketDataReceiver;
import com.tvd12.ezyfoxserver.nio.socket.EzySocketDataReceiver;
import com.tvd12.ezyfoxserver.nio.wrapper.EzyHandlerGroupManager;
import com.tvd12.ezyfoxserver.nio.wrapper.impl.EzyHandlerGroupManagerImpl;
import com.tvd12.ezyfoxserver.setting.EzySocketSetting;
import com.tvd12.ezyfoxserver.socket.EzyBlockingSessionTicketsQueue;
import com.tvd12.ezyfoxserver.socket.EzyBlockingSocketDisconnectionQueue;
import com.tvd12.ezyfoxserver.socket.EzyBlockingSocketStreamQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsRequestQueues;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnectionQueue;
import com.tvd12.ezyfoxserver.socket.EzySocketStreamQueue;
import java.util.concurrent.ExecutorService;

public class EzyNioServerBootstrapBuilderImpl
extends EzyHttpServerBootstrapBuilder
implements EzyNioServerBootstrapBuilder {
    protected EzyServerBootstrap newServerBootstrap() {
        ExecutorService statsThreadPool = this.newStatsThreadPool();
        EzyCodecFactory codecFactory = this.newCodecFactory();
        EzyStreamingApi streamingApi = this.newStreamingApi();
        EzyResponseApi responseApi = this.newResponseApi(codecFactory);
        EzySocketStreamQueue streamQueue = this.newStreamQueue();
        EzySessionTicketsQueue socketSessionTicketsQueue = this.newSocketSessionTicketsQueue();
        EzySessionTicketsQueue websocketSessionTicketsQueue = this.newWebSocketSessionTicketsQueue();
        EzySocketDisconnectionQueue socketDisconnectionQueue = this.newSocketDisconnectionQueue();
        EzySessionTicketsRequestQueues sessionTicketsRequestQueues = this.newSessionTicketsRequestQueues();
        EzyHandlerGroupBuilderFactory handlerGroupBuilderFactory = this.newHandlerGroupBuilderFactory(statsThreadPool, codecFactory, streamQueue, socketDisconnectionQueue, socketSessionTicketsQueue, websocketSessionTicketsQueue, sessionTicketsRequestQueues);
        EzyHandlerGroupManager handlerGroupManager = this.newHandlerGroupManager(handlerGroupBuilderFactory);
        EzySocketDataReceiver socketDataReceiver = this.newSocketDataReceiver(handlerGroupManager);
        EzyNioServerBootstrap bootstrap = new EzyNioServerBootstrap();
        bootstrap.setResponseApi(responseApi);
        bootstrap.setStreamingApi(streamingApi);
        bootstrap.setStreamQueue(streamQueue);
        bootstrap.setSocketDataReceiver(socketDataReceiver);
        bootstrap.setHandlerGroupManager(handlerGroupManager);
        bootstrap.setSocketDisconnectionQueue(socketDisconnectionQueue);
        bootstrap.setSocketSessionTicketsQueue(socketSessionTicketsQueue);
        bootstrap.setWebsocketSessionTicketsQueue(websocketSessionTicketsQueue);
        bootstrap.setSocketSessionTicketsRequestQueues(sessionTicketsRequestQueues);
        bootstrap.setSslContext(this.newSslContext(this.getWebsocketSetting().getSslConfig()));
        return bootstrap;
    }

    private EzyHandlerGroupManager newHandlerGroupManager(EzyHandlerGroupBuilderFactory handlerGroupBuilderFactory) {
        return EzyHandlerGroupManagerImpl.builder().handlerGroupBuilderFactory(handlerGroupBuilderFactory).build();
    }

    private EzyHandlerGroupBuilderFactory newHandlerGroupBuilderFactory(ExecutorService statsThreadPool, EzyCodecFactory codecFactory, EzySocketStreamQueue streamQueue, EzySocketDisconnectionQueue disconnectionQueue, EzySessionTicketsQueue socketSessionTicketsQueue, EzySessionTicketsQueue websocketSessionTicketsQueue, EzySessionTicketsRequestQueues sessionTicketsRequestQueues) {
        return EzyHandlerGroupBuilderFactoryImpl.builder().statistics(this.server.getStatistics()).serverContext(this.serverContext).streamQueue(streamQueue).codecFactory(codecFactory).statsThreadPool(statsThreadPool).disconnectionQueue(disconnectionQueue).socketSessionTicketsQueue(socketSessionTicketsQueue).webSocketSessionTicketsQueue(websocketSessionTicketsQueue).sessionTicketsRequestQueues(sessionTicketsRequestQueues).build();
    }

    protected EzyStreamingApi newStreamingApi() {
        return new EzyProxyStreamingApi();
    }

    protected EzyResponseApi newResponseApi(EzyCodecFactory codecFactory) {
        EzySocketSetting socketSetting = this.getSocketSetting();
        return socketSetting.isCertificationSslActive() ? new EzySecureProxyResponseApi(codecFactory) : new EzyProxyResponseApi(codecFactory);
    }

    private ExecutorService newStatsThreadPool() {
        int threadPoolSize = this.getThreadPoolSizeSetting().getStatistics();
        return EzyExecutors.newFixedThreadPool((int)threadPoolSize, (String)"statistics");
    }

    private EzySocketDataReceiver newSocketDataReceiver(EzyHandlerGroupManager handlerGroupManager) {
        return this.newSocketDataReceiverBuilder().handlerGroupManager(handlerGroupManager).threadPoolSize(this.getThreadPoolSizeSetting().getSocketDataReceiver()).build();
    }

    private EzySocketDataReceiver.Builder newSocketDataReceiverBuilder() {
        EzySocketSetting setting = this.getSocketSetting();
        return setting.isCertificationSslActive() ? EzySecureSocketDataReceiver.builder() : EzySocketDataReceiver.builder();
    }

    private EzySocketStreamQueue newStreamQueue() {
        return new EzyBlockingSocketStreamQueue();
    }

    private EzySessionTicketsQueue newSocketSessionTicketsQueue() {
        return new EzyBlockingSessionTicketsQueue();
    }

    private EzySessionTicketsQueue newWebSocketSessionTicketsQueue() {
        return new EzyBlockingSessionTicketsQueue();
    }

    private EzySocketDisconnectionQueue newSocketDisconnectionQueue() {
        return new EzyBlockingSocketDisconnectionQueue();
    }

    private EzySessionTicketsRequestQueues newSessionTicketsRequestQueues() {
        return new EzySessionTicketsRequestQueues();
    }

    private EzyCodecFactory newCodecFactory() {
        return EzySimpleCodecFactory.builder().socketSetting(this.getSocketSetting()).websocketSetting(this.getWebsocketSetting()).build();
    }
}

