/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.socket;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.exception.EzyConnectionCloseException;
import com.tvd12.ezyfoxserver.nio.socket.EzyNioSocketChannel;
import com.tvd12.ezyfoxserver.socket.EzySecureChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EzyNioSecureSocketChannel
extends EzyNioSocketChannel
implements EzySecureChannel {
    private SSLEngine engine;
    private ByteBuffer netBuffer;
    private int appBufferSize;
    private int netBufferSize;
    private final SSLContext sslContext;
    private final int sslHandshakeTimeout;
    private final int sslMaxAppBufferSize;
    private final Object packingLock = new Object();
    private final AtomicBoolean handshaked = new AtomicBoolean();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public EzyNioSecureSocketChannel(SocketChannel channel, SSLContext sslContext, int sslHandshakeTimeout, int maxRequestSize) {
        super(channel);
        this.sslContext = sslContext;
        this.sslHandshakeTimeout = sslHandshakeTimeout;
        this.sslMaxAppBufferSize = maxRequestSize * 2;
    }

    public boolean isHandshaked() {
        return this.handshaked.get();
    }

    public void handshake() throws IOException {
        if (!this.channel.isConnected()) {
            this.logger.info("channel: {} closed", (Object)this.channel);
            return;
        }
        if (this.engine != null) {
            this.logger.info("channel: {} has already called handshake, handshaked: {}", (Object)this.channel, (Object)this.handshaked);
            return;
        }
        this.engine = this.sslContext.createSSLEngine();
        this.engine.setUseClientMode(false);
        this.engine.beginHandshake();
        SSLSession session = this.engine.getSession();
        this.appBufferSize = session.getApplicationBufferSize();
        this.netBufferSize = session.getPacketBufferSize();
        this.netBuffer = ByteBuffer.allocate(this.netBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(this.appBufferSize);
        ByteBuffer peerNetData = ByteBuffer.allocate(this.netBufferSize);
        SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
        long currentTime = System.currentTimeMillis();
        long endTime = currentTime + (long)this.sslHandshakeTimeout;
        block22: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            Runnable task;
            currentTime = System.currentTimeMillis();
            if (currentTime >= endTime) {
                throw new SSLException("Timeout");
            }
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult result;
                    int readBytes = this.channel.read(peerNetData);
                    if (readBytes < 0) {
                        if (this.engine.isInboundDone() && this.engine.isOutboundDone()) {
                            throw new SSLException("status is NEED_UNWRAP while inbound and outbound done");
                        }
                        try {
                            this.engine.closeInbound();
                        }
                        catch (SSLException e) {
                            this.logger.info("this engine was forced to close inbound, without having received the proper SSL/TLS close notification message from the peer, due to end of stream.", (Throwable)e);
                        }
                        this.engine.closeOutbound();
                        handshakeStatus = this.engine.getHandshakeStatus();
                        continue block22;
                    }
                    peerNetData.flip();
                    try {
                        result = this.engine.unwrap(peerNetData, peerAppData);
                        peerNetData.compact();
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException e) {
                        this.logger.info("a problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...", (Throwable)e);
                        this.engine.closeOutbound();
                        handshakeStatus = this.engine.getHandshakeStatus();
                        continue block22;
                    }
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            throw new EzyConnectionCloseException("max request size");
                        }
                        case BUFFER_UNDERFLOW: {
                            continue block22;
                        }
                        case CLOSED: {
                            if (this.engine.isOutboundDone()) {
                                throw new SSLException("status CLOSED while outbound done");
                            }
                            this.engine.closeOutbound();
                            handshakeStatus = this.engine.getHandshakeStatus();
                            continue block22;
                        }
                    }
                    continue block22;
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    this.netBuffer.clear();
                    try {
                        result = this.engine.wrap(EMPTY_BUFFER, this.netBuffer);
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException e) {
                        this.engine.closeOutbound();
                        handshakeStatus = this.engine.getHandshakeStatus();
                        this.logger.info("a problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...", (Throwable)e);
                        continue block22;
                    }
                    switch (result.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            this.netBuffer = ByteBuffer.allocate(this.netBuffer.capacity() * 2);
                            continue block22;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("should not happen, buffer underflow occurred after a wrap.");
                        }
                        case CLOSED: {
                            try {
                                this.writeOrTimeout(this.channel, this.netBuffer, endTime);
                                peerNetData.clear();
                            }
                            catch (Exception e) {
                                this.logger.info("failed to send server's close message due to socket channel's failure.", (Throwable)e);
                                handshakeStatus = this.engine.getHandshakeStatus();
                            }
                            continue block22;
                        }
                    }
                    this.writeOrTimeout(this.channel, this.netBuffer, endTime);
                    continue block22;
                }
            }
            while ((task = this.engine.getDelegatedTask()) != null) {
                task.run();
            }
            handshakeStatus = this.engine.getHandshakeStatus();
        }
        this.handshaked.set(true);
    }

    public byte[] read(ByteBuffer buffer) throws Exception {
        if (this.netBuffer.position() > 0) {
            this.netBuffer.compact();
        }
        this.netBuffer.put(buffer);
        this.netBuffer.flip();
        ByteBuffer tcpAppBuffer = ByteBuffer.allocate(this.appBufferSize);
        block7: while (this.netBuffer.hasRemaining()) {
            SSLEngineResult result = this.engine.unwrap(this.netBuffer, tcpAppBuffer);
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    int doubleSize = tcpAppBuffer.capacity() * 2;
                    if (doubleSize > this.sslMaxAppBufferSize) {
                        throw new EzyConnectionCloseException("max request size");
                    }
                    tcpAppBuffer = ByteBuffer.allocate(doubleSize);
                    continue block7;
                }
                case BUFFER_UNDERFLOW: {
                    continue block7;
                }
                case CLOSED: {
                    try {
                        this.engine.closeOutbound();
                    }
                    catch (Throwable e) {
                        throw new EzyConnectionCloseException("ssl unwrap result status is CLOSE", e);
                    }
                    throw new EzyConnectionCloseException("ssl unwrap result status is CLOSE");
                }
            }
            tcpAppBuffer.flip();
            byte[] binary = new byte[tcpAppBuffer.limit()];
            tcpAppBuffer.get(binary);
            return binary;
        }
        return new byte[0];
    }

    public byte[] pack(byte[] bytes) throws Exception {
        if (!this.handshaked.get()) {
            throw new SSLException("not handshaked");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        ByteBuffer netBuffer = ByteBuffer.allocate(this.netBufferSize);
        block7: while (buffer.hasRemaining()) {
            SSLEngineResult result = this.engine.wrap(buffer, netBuffer);
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    netBuffer = ByteBuffer.allocate(netBuffer.capacity() * 2);
                    continue block7;
                }
                case BUFFER_UNDERFLOW: {
                    throw new IOException("should not happen, buffer underflow occurred after a wrap.");
                }
                case CLOSED: {
                    try {
                        this.engine.closeOutbound();
                    }
                    catch (Throwable e) {
                        throw new EzyConnectionCloseException("ssl wrap result status is CLOSE", e);
                    }
                    throw new EzyConnectionCloseException("ssl wrap result status is CLOSE");
                }
            }
            netBuffer.flip();
            byte[] answer = new byte[netBuffer.limit()];
            netBuffer.get(answer);
            return answer;
        }
        return bytes;
    }

    public void writeOrTimeout(SocketChannel channel, ByteBuffer buffer, long timeoutAt) throws IOException {
        long currentTime;
        buffer.flip();
        while (buffer.hasRemaining() && (currentTime = System.currentTimeMillis()) < timeoutAt) {
            channel.write(buffer);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.engine != null) {
            EzyProcessor.processWithLogException(this.engine::closeOutbound);
        }
    }

    public Object getPackingLock() {
        return this.packingLock;
    }
}

