/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.context;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.entity.EzyEntity;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyInitable;
import com.tvd12.ezyfox.util.EzyStoppable;
import com.tvd12.ezyfoxserver.EzyComponent;
import com.tvd12.ezyfoxserver.command.EzyAddCommand;
import com.tvd12.ezyfoxserver.command.EzyAddExceptionHandler;
import com.tvd12.ezyfoxserver.command.EzyHandleException;
import com.tvd12.ezyfoxserver.command.impl.EzyAddCommandImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyAddExceptionHandlerImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyHandleExceptionImpl;
import com.tvd12.ezyfoxserver.controller.EzyEventController;
import com.tvd12.ezyfoxserver.event.EzyEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EzyAbstractContext
extends EzyEntity
implements EzyInitable,
EzyDestroyable {
    protected EzyComponent component;
    protected Map<Class, Supplier> commandSuppliers;
    protected EzyHandleException handleException;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public final void init() {
        this.commandSuppliers = this.defaultCommandSuppliers();
        this.handleException = new EzyHandleExceptionImpl(this.component);
        this.properties.put(EzyHandleException.class, this.handleException);
        this.properties.put(EzyAddCommand.class, new EzyAddCommandImpl(this));
        this.properties.put(EzyAddExceptionHandler.class, new EzyAddExceptionHandlerImpl(this.component));
        this.doInit();
    }

    protected void doInit() {
    }

    public <T> T get(Class<T> clazz) {
        Object property = this.getProperty(clazz);
        if (property != null) {
            return (T)property;
        }
        return this.parentGet(clazz);
    }

    protected abstract <T> T parentGet(Class<T> var1);

    public <T> T cmd(Class<T> clazz) {
        Supplier supplier = this.commandSuppliers.get(clazz);
        if (supplier != null) {
            return supplier.get();
        }
        Object property = this.getProperty(clazz);
        if (property != null) {
            return (T)property;
        }
        return this.parentCmd(clazz);
    }

    protected abstract <T> T parentCmd(Class<T> var1);

    public void handleEvent(EzyConstant eventType, EzyEvent event) {
        List<EzyEventController> controllers = this.component.getEventControllers().getControllers(eventType);
        for (EzyEventController controller : controllers) {
            controller.handle(this, event);
        }
    }

    public void handleException(Thread thread, Throwable throwable) {
        this.handleException.handle(thread, throwable);
    }

    protected Map<Class, Supplier> defaultCommandSuppliers() {
        ConcurrentHashMap<Class, Supplier> answer = new ConcurrentHashMap<Class, Supplier>();
        this.addCommandSuppliers(answer);
        return answer;
    }

    protected void addCommandSuppliers(Map<Class, Supplier> suppliers) {
    }

    public void addCommand(Class commandType, Supplier commandSupplier) {
        this.commandSuppliers.put(commandType, commandSupplier);
    }

    public void destroy() {
        this.preDestroy();
        for (Object property : this.properties.values()) {
            if (property instanceof EzyStoppable) {
                ((EzyStoppable)property).stop();
            }
            if (!(property instanceof EzyDestroyable)) continue;
            ((EzyDestroyable)property).destroy();
        }
        this.properties.clear();
        this.commandSuppliers.clear();
        this.component = null;
        this.commandSuppliers = null;
        this.handleException = null;
    }

    protected void preDestroy() {
    }

    protected void postDestroy() {
    }
}

