/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.context;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyEquals;
import com.tvd12.ezyfox.util.EzyHashCodes;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.EzyComponent;
import com.tvd12.ezyfoxserver.EzyZone;
import com.tvd12.ezyfoxserver.command.EzyBroadcastAppsEvent;
import com.tvd12.ezyfoxserver.command.EzyBroadcastEvent;
import com.tvd12.ezyfoxserver.command.EzyBroadcastPluginsEvent;
import com.tvd12.ezyfoxserver.command.impl.EzyBroadcastAppsEventImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyBroadcastPluginsEventImpl;
import com.tvd12.ezyfoxserver.command.impl.EzyZoneBroadcastEventImpl;
import com.tvd12.ezyfoxserver.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.context.EzyAbstractComplexContext;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.context.EzyChildContext;
import com.tvd12.ezyfoxserver.context.EzyPluginContext;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.event.EzyEvent;
import com.tvd12.ezyfoxserver.response.EzyResponse;
import com.tvd12.ezyfoxserver.setting.EzyAppSetting;
import com.tvd12.ezyfoxserver.setting.EzyPluginSetting;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class EzySimpleZoneContext
extends EzyAbstractComplexContext
implements EzyZoneContext,
EzyChildContext {
    protected EzyZone zone;
    protected EzyServerContext parent;
    protected EzyBroadcastEvent broadcastEvent;
    protected EzyBroadcastAppsEvent broadcastAppsEvent;
    protected EzyBroadcastPluginsEvent broadcastPluginsEvent;
    protected final Map<String, EzyAppContext> appContextsByName = new ConcurrentHashMap<String, EzyAppContext>();
    protected final Map<String, EzyPluginContext> pluginContextsByName = new ConcurrentHashMap<String, EzyPluginContext>();

    @Override
    protected void doInit() {
        this.broadcastEvent = new EzyZoneBroadcastEventImpl(this);
        this.broadcastAppsEvent = new EzyBroadcastAppsEventImpl(this);
        this.broadcastPluginsEvent = new EzyBroadcastPluginsEventImpl(this);
        this.properties.put(EzyBroadcastEvent.class, this.broadcastEvent);
        this.properties.put(EzyBroadcastAppsEvent.class, this.broadcastAppsEvent);
        this.properties.put(EzyBroadcastPluginsEvent.class, this.broadcastPluginsEvent);
    }

    @Override
    protected <T> T parentGet(Class<T> clazz) {
        return this.parent.get(clazz);
    }

    @Override
    protected <T> T parentCmd(Class<T> clazz) {
        return this.parent.cmd(clazz);
    }

    @Override
    public void broadcast(EzyConstant eventType, EzyEvent event, boolean catchException) {
        this.broadcastEvent.fire(eventType, event, catchException);
    }

    @Override
    public void broadcastPlugins(EzyConstant type, EzyEvent event, boolean catchException) {
        this.broadcastPluginsEvent.fire(type, event, catchException);
    }

    @Override
    public void broadcastApps(EzyConstant type, EzyEvent event, boolean catchException) {
        this.broadcastAppsEvent.fire(type, event, catchException);
    }

    @Override
    public void broadcastApps(EzyConstant type, EzyEvent event, String username, boolean catchException) {
        this.broadcastAppsEvent.fire(type, event, username, catchException);
    }

    @Override
    public void broadcastApps(EzyConstant type, EzyEvent event, EzyUser user, boolean catchException) {
        this.broadcastAppsEvent.fire(type, event, user, catchException);
    }

    @Override
    public void broadcastApps(EzyConstant type, EzyEvent event, Predicate<EzyAppContext> filter, boolean catchException) {
        this.broadcastAppsEvent.fire(type, event, filter, catchException);
    }

    @Override
    public void addAppContext(EzyAppSetting app, EzyAppContext appContext) {
        super.addAppContext(app, appContext);
        this.appContextsByName.put(app.getName(), appContext);
    }

    @Override
    public void addPluginContext(EzyPluginSetting plugin, EzyPluginContext pluginContext) {
        super.addPluginContext(plugin, pluginContext);
        this.pluginContextsByName.put(plugin.getName(), pluginContext);
    }

    @Override
    public EzyAppContext getAppContext(String appName) {
        EzyAppContext appContext = this.appContextsByName.get(appName);
        if (appContext != null) {
            return appContext;
        }
        throw new IllegalArgumentException("has not app with name = " + appName);
    }

    @Override
    public EzyPluginContext getPluginContext(String pluginName) {
        EzyPluginContext pluginContext = this.pluginContextsByName.get(pluginName);
        if (pluginContext != null) {
            return pluginContext;
        }
        throw new IllegalArgumentException("has not plugin with name = " + pluginName);
    }

    public void setZone(EzyZone zone) {
        this.zone = zone;
        this.component = (EzyComponent)((Object)zone);
    }

    @Override
    public void send(EzyResponse response, EzySession recipient, boolean encrypted, EzyTransportType transportType) {
        this.parent.send(response, recipient, encrypted, transportType);
    }

    @Override
    public void send(EzyResponse response, Collection<EzySession> recipients, boolean encrypted, EzyTransportType transportType) {
        this.parent.send(response, recipients, encrypted, transportType);
    }

    @Override
    public void stream(byte[] bytes, EzySession recipient, EzyTransportType transportType) {
        this.parent.stream(bytes, recipient, transportType);
    }

    @Override
    public void stream(byte[] bytes, Collection<EzySession> recipients, EzyTransportType transportType) {
        this.parent.stream(bytes, recipients, transportType);
    }

    @Override
    protected void destroyComponents() {
        this.destroyAppContexts();
        this.destroyPluginContexts();
        this.destroyZone();
    }

    @Override
    protected void clearProperties() {
        super.clearProperties();
        this.zone = null;
        this.parent = null;
        this.broadcastEvent = null;
        this.broadcastAppsEvent = null;
        this.broadcastPluginsEvent = null;
        this.appContextsByName.clear();
        this.pluginContextsByName.clear();
    }

    private void destroyAppContexts() {
        for (EzyAppContext ac : this.appContexts) {
            this.destroyAppContext(ac);
        }
    }

    private void destroyPluginContexts() {
        for (EzyPluginContext pc : this.pluginContexts) {
            this.destroyPluginContext(pc);
        }
    }

    private void destroyZone() {
        EzyProcessor.processWithLogException(() -> ((EzyDestroyable)this.zone).destroy());
    }

    private void destroyAppContext(EzyAppContext appContext) {
        EzyProcessor.processWithLogException(() -> ((EzyDestroyable)((EzyDestroyable)appContext)).destroy());
    }

    private void destroyPluginContext(EzyPluginContext pluginContext) {
        EzyProcessor.processWithLogException(() -> ((EzyDestroyable)((EzyDestroyable)pluginContext)).destroy());
    }

    public boolean equals(Object obj) {
        return new EzyEquals().function(t -> t.zone).isEquals((Object)this, obj);
    }

    public int hashCode() {
        return new EzyHashCodes().append((Object)this.zone).toHashCode();
    }

    @Override
    protected void preDestroy() {
        this.logger.debug("destroy ZoneContext({})", (Object)this.zone);
    }

    @Override
    public EzyZone getZone() {
        return this.zone;
    }

    public void setParent(EzyServerContext parent) {
        this.parent = parent;
    }

    @Override
    public EzyServerContext getParent() {
        return this.parent;
    }
}

