/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.installer.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import org.youngmonkeys.ezyplatform.installer.io.InstallFolderProxy;

public class InstallerFilesUpdater {
    private InstallerFilesUpdater() {
    }

    public static void deleteCurrentFolders(Set<String> updateFiles) throws IOException {
        for (String updateFile : updateFiles) {
            Path toDeleteFolder = InstallFolderProxy.getFilePath(updateFile, new String[0]);
            if (!Files.exists(toDeleteFolder, new LinkOption[0]) || !Files.isDirectory(toDeleteFolder, new LinkOption[0])) continue;
            InstallFolderProxy.deleteFolder(toDeleteFolder);
        }
    }

    public static void replaceNewFiles(Set<String> updateFiles) throws IOException {
        Path platformFolder = InstallFolderProxy.getUploadEzyPlatformFolder();
        for (String updateFile : updateFiles) {
            InstallerFilesUpdater.replaceNewFile(platformFolder, updateFile);
        }
    }

    private static void replaceNewFile(Path platformFolder, String updateFile) throws IOException {
        Path updateFilePath = platformFolder.resolve(updateFile);
        if (!Files.exists(updateFilePath, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(updateFilePath, new LinkOption[0])) {
            InstallFolderProxy.copyFolder(updateFilePath, InstallFolderProxy.getFilePath(updateFile, new String[0]));
        } else {
            InstallFolderProxy.copyFile(updateFilePath, InstallFolderProxy.getFilePath(updateFile, new String[0]));
        }
    }
}

