/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller.api;

import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import java.util.Set;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.response.CountResponse;
import org.youngmonkeys.ezyplatform.web.annotation.UserId;
import org.youngmonkeys.ezyplatform.web.controller.service.WebLetterControllerService;
import org.youngmonkeys.ezyplatform.web.request.ReadLettersRequest;
import org.youngmonkeys.ezyplatform.web.response.LetterResponse;
import org.youngmonkeys.ezyplatform.web.service.WebLetterService;
import org.youngmonkeys.ezyplatform.web.validator.WebCommonValidator;

public class WebApiLetterController {
    private final WebLetterService letterService;
    private final WebLetterControllerService letterControllerService;
    private final WebCommonValidator commonValidator;

    @DoGet(value="/account/letters/count")
    public CountResponse accountLettersCount(@UserId long userId) {
        return new CountResponse(this.letterService.countUserUnreadLetters(userId));
    }

    @DoGet(value="/account/letters")
    public PaginationModel<LetterResponse> accountLettersGet(@UserId long userId, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="12") int limit) {
        this.commonValidator.validatePageSize(limit);
        return this.letterControllerService.getUserLetters(userId, nextPageToken, prevPageToken, lastPage, limit);
    }

    @DoPost(value="/account/letters/{id}/read")
    public ResponseEntity accountLettersIdReadPost(@UserId long userId, @PathVariable long letterId) {
        this.letterService.updateUserLetterByRead(userId, letterId);
        return ResponseEntity.noContent();
    }

    @DoPost(value="/account/letters/read")
    public ResponseEntity accountLettersReadPost(@UserId long userId, @RequestBody ReadLettersRequest request) {
        this.letterService.updateUserLettersByRead(userId, request.getLetterIds());
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/account/letters")
    public ResponseEntity accountLettersDelete(@UserId long userId, @RequestParam(value="ids") Set<Long> ids) {
        this.commonValidator.validateCollectionSize("letterIds", ids);
        this.letterService.deleteUserLetters(userId, ids);
        return ResponseEntity.noContent();
    }

    public WebApiLetterController(WebLetterService letterService, WebLetterControllerService letterControllerService, WebCommonValidator commonValidator) {
        this.letterService = letterService;
        this.letterControllerService = letterControllerService;
        this.commonValidator = commonValidator;
    }
}

