/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;
import org.youngmonkeys.ezyplatform.web.request.UpdatePasswordRequest;
import org.youngmonkeys.ezyplatform.web.request.UpdateUserRequest;
import org.youngmonkeys.ezyplatform.web.service.WebUserService;

@EzySingleton
public class WebUserValidator {
    private final WebUserService userService;

    public UserModel validateUserId(long userId) {
        UserModel user = this.userService.getUserById(userId);
        if (user == null) {
            throw new HttpNotFoundException(Collections.singletonMap("user", "notFound"));
        }
        return user;
    }

    public void validate(long userId, UpdatePasswordRequest request) {
        HashMap<String, String> errors = new HashMap<String, String>();
        boolean hasAutoGeneratedPassword = this.userService.isUserHasAutoGeneratedPassword(userId);
        if (!hasAutoGeneratedPassword) {
            if (EzyStrings.isBlank((String)request.getOldPassword())) {
                errors.put("password", "required");
            } else if (!DefaultValidator.isValidPassword((String)request.getOldPassword())) {
                errors.put("password", "invalid");
            }
        }
        if (!DefaultValidator.isValidPassword((String)request.getNewPassword())) {
            errors.put("newPassword", "invalid");
        } else if (request.getNewPassword().equals(request.getOldPassword())) {
            errors.put("newPassword", "must_be_difference_old_password");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long userId, UpdateUserRequest request) {
        String displayName;
        String website;
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyStrings.isEmpty((CharSequence)request.getEmail())) {
            errors.put("email", "required");
        } else if (!DefaultValidator.isValidEmail((String)request.getEmail())) {
            errors.put("email", "invalid");
        } else {
            UserModel userModel = this.userService.getUserByEmail(request.getEmail());
            if (userModel != null && userModel.getId() != userId) {
                errors.put("email", "duplicated");
            }
        }
        String phone = request.getPhone();
        if (EzyStrings.isNotBlank((String)phone)) {
            if (!DefaultValidator.isValidPhone((String)phone)) {
                errors.put("phone", "invalid");
            } else {
                UserModel userModel = this.userService.getUserByPhone(phone.trim());
                if (userModel != null && userModel.getId() != userId) {
                    errors.put("phone", "duplicated");
                }
            }
        }
        if (EzyStrings.isNotBlank((String)(website = request.getWebsite())) && !DefaultValidator.isValidHttpUrl((String)website)) {
            errors.put("website", "invalid");
        }
        if (EzyStrings.isNotBlank((String)(displayName = request.getDisplayName())) && DefaultValidator.containsSqlComment((String)displayName)) {
            errors.put("displayName", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public WebUserValidator(WebUserService userService) {
        this.userService = userService;
    }
}

