/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.config;

import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.bean.annotation.EzyConfiguration;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyhttp.core.net.URIBuilder;
import com.tvd12.ezyhttp.server.core.handler.RequestURIDecorator;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.util.Uris;

@EzyConfiguration
public class AdminRequestUriDecorator
implements RequestURIDecorator {
    @EzyAutoBind
    private AdminModuleManager moduleManager;

    public String decorate(EzyClass controllerClass, String originalUri) {
        String controllerPackage = controllerClass.getClazz().getPackage().getName();
        Module module = this.moduleManager.findAdminModuleByPackage(controllerPackage);
        if (module == null) {
            return originalUri;
        }
        String moduleNameDashCase = EzyStrings.toDashCase((String)module.getName());
        if (Uris.uriStartsWith((String)originalUri, (String)moduleNameDashCase)) {
            return originalUri;
        }
        return URIBuilder.normalizePath((String)("/" + EzyStrings.toDashCase((String)module.getName()) + "/" + originalUri));
    }

    public void setModuleManager(AdminModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

