/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import org.youngmonkeys.ezyplatform.admin.bash.AdminBash;
import org.youngmonkeys.ezyplatform.admin.bash.AdminCommand;
import org.youngmonkeys.ezyplatform.admin.data.Target;
import org.youngmonkeys.ezyplatform.admin.manager.AdminTargetManager;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.statistics.AdminEzyPlatformStatisticsSender;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.entity.TargetType;

@Api
@Authenticated
@EzyFeature(value="devops")
@Controller(value="/api/v1")
public class AdminApiManagementController {
    private final AdminBash bash;
    private final AdminTargetManager targetManager;
    private final AdminSettingService settingService;
    private final AdminCommonValidator commonValidator;
    private final AdminEzyPlatformStatisticsSender platformStatisticsSender;

    @DoPost(value="/enable")
    public ResponseEntity enablePost(@RequestParam(value="target") String target) {
        return this.doTargetAction(target, AdminCommand.ENABLE);
    }

    @DoPost(value="/disable")
    public ResponseEntity disablePost(@RequestParam(value="target") String target) {
        return this.doTargetAction(target, AdminCommand.DISABLE);
    }

    @DoPost(value="/start")
    public ResponseEntity startPost(@RequestParam(value="target") String target) {
        return this.doTargetAction(target, AdminCommand.START);
    }

    @DoPost(value="/stop")
    public ResponseEntity stopPost(@RequestParam(value="target") String target) {
        ResponseEntity answer = this.doTargetAction(target, AdminCommand.STOP);
        this.platformStatisticsSender.sendTargetStopStatistics(target);
        return answer;
    }

    @DoPost(value="/restart")
    public ResponseEntity restartPost(@RequestParam(value="target") String target) {
        return this.doTargetAction(target, AdminCommand.RESTART);
    }

    private ResponseEntity doTargetAction(String target, AdminCommand command) {
        TargetType targetType = this.commonValidator.validateTarget(target);
        AdminCommand statusCommand = null;
        AdminCommand bashCommand = null;
        if (command == AdminCommand.ENABLE || command == AdminCommand.DISABLE) {
            statusCommand = command;
            if (command == AdminCommand.DISABLE) {
                bashCommand = AdminCommand.STOP;
            }
        } else {
            bashCommand = command;
            if (command == AdminCommand.START || command == AdminCommand.RESTART) {
                statusCommand = AdminCommand.ENABLE;
            }
        }
        if (statusCommand != null) {
            boolean enable = statusCommand == AdminCommand.ENABLE;
            this.settingService.setBooleanValue(target + "_enable", enable);
            Target targetData = this.targetManager.getTarget(targetType);
            targetData.setEnable(enable);
            this.targetManager.saveTarget(targetData);
        }
        if (bashCommand != null) {
            this.bash.run(bashCommand, target);
        }
        return ResponseEntity.noContent();
    }

    public AdminApiManagementController(AdminBash bash, AdminTargetManager targetManager, AdminSettingService settingService, AdminCommonValidator commonValidator, AdminEzyPlatformStatisticsSender platformStatisticsSender) {
        this.bash = bash;
        this.targetManager = targetManager;
        this.settingService = settingService;
        this.commonValidator = commonValidator;
        this.platformStatisticsSender = platformStatisticsSender;
    }
}

