/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.youngmonkeys.ezyplatform.admin.entity.AdminProject;
import org.youngmonkeys.ezyplatform.admin.entity.RunScriptHistory;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminModel;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminProjectModel;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminRoleModel;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.model.AddContentTemplateModel;
import org.youngmonkeys.ezyplatform.admin.model.AddUserModel;
import org.youngmonkeys.ezyplatform.admin.model.AddUserRoleModel;
import org.youngmonkeys.ezyplatform.admin.model.AddUserRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.model.RunScriptHistoryModel;
import org.youngmonkeys.ezyplatform.admin.model.SaveSettingModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateAdminModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateAdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateContentTemplateModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateUserModel;
import org.youngmonkeys.ezyplatform.admin.model.UpdateUserRoleNameModel;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.AccessTokenStatus;
import org.youngmonkeys.ezyplatform.entity.Admin;
import org.youngmonkeys.ezyplatform.entity.AdminAccessToken;
import org.youngmonkeys.ezyplatform.entity.AdminRole;
import org.youngmonkeys.ezyplatform.entity.AdminRoleName;
import org.youngmonkeys.ezyplatform.entity.AdminStatus;
import org.youngmonkeys.ezyplatform.entity.ContentTemplate;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.entity.RoleFeature;
import org.youngmonkeys.ezyplatform.entity.RoleFeatureId;
import org.youngmonkeys.ezyplatform.entity.Setting;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.entity.UserRole;
import org.youngmonkeys.ezyplatform.entity.UserRoleName;
import org.youngmonkeys.ezyplatform.entity.UserStatus;
import org.youngmonkeys.ezyplatform.manager.PasswordManager;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.util.Sha256Uuids;
import org.youngmonkeys.ezyplatform.util.StringConverters;

@EzySingleton
public class AdminModelToEntityConverter
extends DefaultModelToEntityConverter {
    private final PasswordManager passwordManager;

    public AdminModelToEntityConverter(ClockProxy clock, ObjectMapper objectMapper, PasswordManager passwordManager) {
        super(clock, objectMapper);
        this.passwordManager = passwordManager;
    }

    public Admin toEntity(AddAdminModel model) {
        Admin entity = new Admin();
        entity.setUuid(Sha256Uuids.generateUuid((String)model.getUsername()));
        entity.setUsername(model.getUsername());
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setEmail(model.getEmail());
        entity.setPhone(StringConverters.trimOrNull((String)model.getPhone()));
        entity.setUrl(StringConverters.trimOrNull((String)model.getWebsite()));
        entity.setPassword(this.passwordManager.hashPassword(model.getPassword()));
        entity.setStatus(AdminStatus.ACTIVATED);
        LocalDateTime now = this.clock.nowDateTime();
        entity.setCreatedAt(now);
        entity.setUpdatedAt(now);
        return entity;
    }

    public AdminRoleName toEntity(AddAdminRoleNameModel model) {
        AdminRoleName entity = new AdminRoleName();
        entity.setName(StringConverters.trimOrNull((String)model.getName()));
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setPriority(model.getPriority());
        LocalDateTime now = this.clock.nowDateTime();
        entity.setCreatedAt(now);
        entity.setUpdatedAt(now);
        return entity;
    }

    public AdminRole toEntity(AddAdminRoleModel model) {
        AdminRole entity = new AdminRole();
        entity.setAdminId(model.getAdminId());
        entity.setRoleId(model.getRoleId());
        LocalDateTime now = this.clock.nowDateTime();
        entity.setCreatedAt(now);
        return entity;
    }

    public User toEntity(AddUserModel model) {
        User entity = new User();
        entity.setUuid(Sha256Uuids.generateUuid((String)model.getUsername()));
        entity.setUsername(StringConverters.trimOrNull((String)model.getUsername()));
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setEmail(StringConverters.trimOrNull((String)model.getEmail()));
        entity.setPhone(StringConverters.trimOrNull((String)model.getPhone()));
        entity.setUrl(StringConverters.trimOrNull((String)model.getWebsite()));
        entity.setPassword(this.passwordManager.hashPassword(model.getPassword()));
        entity.setStatus(UserStatus.ACTIVATED.toString());
        LocalDateTime now = this.clock.nowDateTime();
        entity.setCreatedAt(now);
        entity.setUpdatedAt(now);
        return entity;
    }

    public UserRole toEntity(AddUserRoleModel model) {
        UserRole entity = new UserRole();
        entity.setUserId(model.getUserId());
        entity.setRoleId(model.getRoleId());
        entity.setCreatedAt(this.clock.nowDateTime());
        return entity;
    }

    public UserRoleName toEntity(AddUserRoleNameModel model) {
        UserRoleName entity = new UserRoleName();
        entity.setName(StringConverters.trimOrNull((String)model.getName()));
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setPriority(model.getPriority());
        LocalDateTime now = this.clock.nowDateTime();
        entity.setCreatedAt(now);
        entity.setUpdatedAt(now);
        return entity;
    }

    public RunScriptHistory toEntity(RunScriptHistoryModel model) {
        RunScriptHistory entity = new RunScriptHistory();
        entity.setModuleType(model.getModuleType());
        entity.setModuleName(model.getModuleName());
        entity.setScriptName(model.getScriptName());
        entity.setRunAt(this.clock.nowDateTime());
        return entity;
    }

    public Setting toEntity(SaveSettingModel model) {
        Setting entity = new Setting();
        this.mergeToEntity(model, entity);
        entity.setCreatedAt(entity.getUpdatedAt());
        return entity;
    }

    public AdminProject toEntity(AddAdminProjectModel model) {
        AdminProject entity = new AdminProject();
        entity.setProjectName(model.getProjectName());
        entity.setVersionName(model.getVersion());
        entity.setUpdatedByAdminId(model.getAdminId());
        entity.setUpdatedAt(this.clock.nowDateTime());
        return entity;
    }

    public ContentTemplate toEntity(long creatorId, String templateType, AddContentTemplateModel model) {
        LocalDateTime now = this.clock.nowDateTime();
        String templateName = EzyStrings.isBlank((String)model.getTemplateName()) ? UUID.randomUUID().toString() : model.getTemplateName();
        ContentTemplate entity = new ContentTemplate();
        entity.setTemplateType(templateType);
        entity.setTemplateName(StringConverters.trimOrNull((String)templateName));
        entity.setTitleTemplate(model.getTitleTemplate());
        entity.setContentTemplate(model.getContentTemplate());
        entity.setContentType(model.getContentType());
        entity.setStatus(model.getStatus());
        entity.setCreatorId(creatorId);
        entity.setCreatedAt(now);
        entity.setUpdatedAt(now);
        return entity;
    }

    public Map<RoleFeatureId, RoleFeature> toRoleFeatureEntityMap(long roleId, String targetType, Map<String, Map<String, List<String>>> methodsUriMapByFeature) {
        LocalDateTime now = this.clock.nowDateTime();
        HashMap<RoleFeatureId, RoleFeature> map = new HashMap<RoleFeatureId, RoleFeature>();
        for (String feature : methodsUriMapByFeature.keySet()) {
            Map<String, List<String>> methodsUriMap = methodsUriMapByFeature.get(feature);
            for (String uri : methodsUriMap.keySet()) {
                List<String> methods = methodsUriMap.get(uri);
                ArrayList<String> actualUris = new ArrayList<String>();
                actualUris.add(uri);
                if (uri.length() > 1) {
                    if (uri.endsWith("/")) {
                        actualUris.add(uri.substring(0, uri.length() - 1));
                    } else {
                        actualUris.add(uri + "/");
                    }
                }
                for (String actualUri : actualUris) {
                    for (String method : methods) {
                        RoleFeature entity = new RoleFeature(roleId, targetType, feature, actualUri, method, now);
                        map.put(entity.identifier(), entity);
                    }
                }
            }
        }
        return map;
    }

    public void toDeletedUserEntity(User entity) {
        long userId = entity.getId();
        String newUserName = "UnknownUser" + userId;
        String newEmail = newUserName + "@unknown.user";
        entity.setUsername(newUserName);
        entity.setEmail(newEmail);
        entity.setUrl("");
        entity.setPhone(null);
        entity.setDisplayName("");
        entity.setPassword(this.passwordManager.hashPassword(UUID.randomUUID().toString()));
        entity.setAvatarImageId(0L);
        entity.setCoverImageId(0L);
        entity.setActivationKey(null);
        entity.setStatus(UserStatus.DELETED.toString());
    }

    public AdminAccessToken toAdminAccessTokenEntity(long adminId, String token, long tokenExpiredTimeInDay, AccessTokenStatus status) {
        LocalDateTime now = this.clock.nowDateTime();
        LocalDateTime expiredAt = now.plusDays(tokenExpiredTimeInDay);
        AdminAccessToken adminAccessToken = new AdminAccessToken();
        adminAccessToken.setId(token);
        adminAccessToken.setAdminId(adminId);
        adminAccessToken.setStatus(status);
        adminAccessToken.setCreatedAt(now);
        adminAccessToken.setExpiredAt(expiredAt);
        return adminAccessToken;
    }

    public void mergeToEntity(SaveSettingModel model, Setting entity) {
        entity.setName(model.getName());
        entity.setDataType(model.getDataType());
        entity.setValue(model.getDataType() == DataType.JSON ? this.valueToJson(model.getValue()) : String.valueOf(model.getValue()));
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(UpdateAdminModel model, Admin entity) {
        entity.setEmail(StringConverters.trimOrNull((String)model.getEmail()));
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setPhone(StringConverters.trimOrNull((String)model.getPhone()));
        entity.setUrl(StringConverters.trimOrNull((String)model.getWebsite()));
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(UpdateUserModel model, User entity) {
        entity.setEmail(StringConverters.trimOrNull((String)model.getEmail()));
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setPhone(StringConverters.trimOrNull((String)model.getPhone()));
        entity.setUrl(StringConverters.trimOrNull((String)model.getWebsite()));
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(UpdateContentTemplateModel model, ContentTemplate entity) {
        entity.setTemplateName(StringConverters.trimOrNull((String)model.getTemplateName()));
        entity.setTitleTemplate(model.getTitleTemplate());
        entity.setContentTemplate(model.getContentTemplate());
        entity.setStatus(model.getStatus());
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(UpdateAdminRoleNameModel model, AdminRoleName entity) {
        entity.setName(model.getName());
        entity.setDisplayName(model.getDisplayName());
        entity.setPriority(model.getPriority());
        entity.setUpdatedAt(this.clock.nowDateTime());
    }

    public void mergeToEntity(UpdateUserRoleNameModel model, UserRoleName entity) {
        entity.setName(model.getName());
        entity.setDisplayName(model.getDisplayName());
        entity.setPriority(model.getPriority());
        entity.setUpdatedAt(this.clock.nowDateTime());
    }
}

