/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.support.reflect;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.annotation.EzyManagement;
import com.tvd12.ezyfox.annotation.EzyPayment;
import com.tvd12.ezyfox.core.annotation.EzyDoHandle;
import com.tvd12.ezyfox.core.annotation.EzyTryCatch;
import com.tvd12.ezyfox.core.util.EzyRequestControllerAnnotations;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfoxserver.support.reflect.EzyExceptionHandlerMethod;
import com.tvd12.ezyfoxserver.support.reflect.EzyRequestHandlerMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EzyRequestControllerProxy {
    protected final EzyClass clazz;
    protected final Object instance;
    protected final String commandGroup;
    protected final List<EzyRequestHandlerMethod> requestHandlerMethods;
    protected final List<EzyExceptionHandlerMethod> exceptionHandlerMethods;
    protected final Map<Class<?>, EzyExceptionHandlerMethod> exceptionHandlerMethodMap;

    public EzyRequestControllerProxy(Object instance) {
        this.instance = instance;
        this.clazz = new EzyClass(instance.getClass());
        this.commandGroup = this.getCommandGroup();
        this.requestHandlerMethods = this.fetchRequestHandlerMethods();
        this.exceptionHandlerMethods = this.fetchExceptionHandlerMethods();
        this.exceptionHandlerMethodMap = this.fetchExceptionHandlerMethodMap();
    }

    protected String getCommandGroup() {
        return EzyRequestControllerAnnotations.getGroup((Class)this.clazz.getClazz());
    }

    protected List<EzyRequestHandlerMethod> fetchRequestHandlerMethods() {
        ArrayList<EzyRequestHandlerMethod> list = new ArrayList<EzyRequestHandlerMethod>();
        List methods = this.clazz.getPublicMethods(this::isRequestHandlerMethod);
        for (EzyMethod method : methods) {
            EzyRequestHandlerMethod m = new EzyRequestHandlerMethod(this.commandGroup, method);
            list.add(m);
        }
        return list;
    }

    public List<EzyExceptionHandlerMethod> fetchExceptionHandlerMethods() {
        ArrayList<EzyExceptionHandlerMethod> list = new ArrayList<EzyExceptionHandlerMethod>();
        List methods = this.clazz.getMethods(m -> m.isAnnotated(EzyTryCatch.class));
        for (EzyMethod method : methods) {
            EzyExceptionHandlerMethod m2 = new EzyExceptionHandlerMethod(method);
            list.add(m2);
        }
        return list;
    }

    protected final Map<Class<?>, EzyExceptionHandlerMethod> fetchExceptionHandlerMethodMap() {
        HashMap answer = new HashMap();
        for (EzyExceptionHandlerMethod m : this.exceptionHandlerMethods) {
            for (Class<?> exceptionClass : m.getExceptionClasses()) {
                answer.put(exceptionClass, m);
            }
        }
        return answer;
    }

    protected boolean isRequestHandlerMethod(EzyMethod method) {
        return method.isAnnotated(EzyDoHandle.class);
    }

    public String getControllerName() {
        return this.clazz.getClazz().getSimpleName();
    }

    public boolean isManagement() {
        return this.clazz.isAnnotated(EzyManagement.class);
    }

    public boolean isPayment() {
        return this.clazz.isAnnotated(EzyPayment.class);
    }

    public String getFeature() {
        EzyFeature annotation = (EzyFeature)this.clazz.getAnnotation(EzyFeature.class);
        return annotation != null ? annotation.value() : null;
    }

    public String toString() {
        return this.clazz.getName() + "(\n\tinstance: " + this.instance + ",\n\trequestHandlerMethods: " + this.requestHandlerMethods + ",\n)";
    }

    public EzyClass getClazz() {
        return this.clazz;
    }

    public Object getInstance() {
        return this.instance;
    }

    public List<EzyRequestHandlerMethod> getRequestHandlerMethods() {
        return this.requestHandlerMethods;
    }

    public List<EzyExceptionHandlerMethod> getExceptionHandlerMethods() {
        return this.exceptionHandlerMethods;
    }

    public Map<Class<?>, EzyExceptionHandlerMethod> getExceptionHandlerMethodMap() {
        return this.exceptionHandlerMethodMap;
    }
}

