/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.reflect;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.annotation.EzyManagement;
import com.tvd12.ezyfox.annotation.EzyPayment;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.net.URIBuilder;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.reflect.HandlerMethod;
import com.tvd12.ezyhttp.server.core.util.DoDeleteAnnotations;
import com.tvd12.ezyhttp.server.core.util.DoGetAnnotations;
import com.tvd12.ezyhttp.server.core.util.DoPostAnnotations;
import com.tvd12.ezyhttp.server.core.util.DoPutAnnotations;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RequestHandlerMethod
extends HandlerMethod {
    protected final String rootURI;
    protected final String requestURI;
    protected final String responseType;
    protected final HttpMethod httpMethod;

    private RequestHandlerMethod(String rootURI, String requestURI, HttpMethod httpMethod, String responseType, EzyMethod method) {
        super(method);
        this.rootURI = rootURI;
        this.httpMethod = httpMethod;
        this.responseType = responseType;
        this.requestURI = URIBuilder.normalizePath((String)(rootURI + requestURI));
    }

    public RequestHandlerMethod(String rootURI, EzyMethod method) {
        super(method);
        this.rootURI = rootURI;
        this.requestURI = this.fetchRequestURI(rootURI);
        this.httpMethod = this.fetchHttpMethod();
        this.responseType = this.fetchResponseType();
    }

    protected String fetchRequestURI(String rootURI) {
        String uri = rootURI + this.fetchRequestURIFragment();
        return URIBuilder.normalizePath((String)uri);
    }

    protected String fetchRequestURIFragment() {
        DoGet doGet = (DoGet)this.method.getAnnotation(DoGet.class);
        if (doGet != null) {
            return DoGetAnnotations.getURI(doGet);
        }
        DoPost doPost = (DoPost)this.method.getAnnotation(DoPost.class);
        if (doPost != null) {
            return DoPostAnnotations.getURI(doPost);
        }
        DoPut doPut = (DoPut)this.method.getAnnotation(DoPut.class);
        if (doPut != null) {
            return DoPutAnnotations.getURI(doPut);
        }
        DoDelete doDelete = (DoDelete)this.method.getAnnotation(DoDelete.class);
        return DoDeleteAnnotations.getURI(doDelete);
    }

    protected HttpMethod fetchHttpMethod() {
        DoGet doGet = (DoGet)this.method.getAnnotation(DoGet.class);
        if (doGet != null) {
            return HttpMethod.GET;
        }
        DoPost doPost = (DoPost)this.method.getAnnotation(DoPost.class);
        if (doPost != null) {
            return HttpMethod.POST;
        }
        DoPut doPut = (DoPut)this.method.getAnnotation(DoPut.class);
        if (doPut != null) {
            return HttpMethod.PUT;
        }
        return HttpMethod.DELETE;
    }

    protected String fetchResponseType() {
        DoGet doGet = (DoGet)this.method.getAnnotation(DoGet.class);
        if (doGet != null) {
            return DoGetAnnotations.getResponseType(doGet);
        }
        DoPost doPost = (DoPost)this.method.getAnnotation(DoPost.class);
        if (doPost != null) {
            return DoPostAnnotations.getResponseType(doPost);
        }
        DoPut doPut = (DoPut)this.method.getAnnotation(DoPut.class);
        if (doPut != null) {
            return DoPutAnnotations.getResponseType(doPut);
        }
        DoDelete doDelete = (DoDelete)this.method.getAnnotation(DoDelete.class);
        return DoDeleteAnnotations.getResponseType(doDelete);
    }

    public List<RequestHandlerMethod> duplicatedToOtherRequestHandlerMethods() {
        return EzyLists.newArrayList(this.fetchOtherRequestURIs(), it -> new RequestHandlerMethod(this.rootURI, (String)it, this.httpMethod, this.responseType, this.method));
    }

    protected Set<String> fetchOtherRequestURIs() {
        DoGet doGet = (DoGet)this.method.getAnnotation(DoGet.class);
        if (doGet == null) {
            return Collections.emptySet();
        }
        return Stream.of(doGet.otherUris()).filter(EzyStrings::isNotBlank).collect(Collectors.toSet());
    }

    public boolean isApi() {
        return this.method.isAnnotated(Api.class);
    }

    public boolean isAuthenticated() {
        return this.method.isAnnotated(Authenticated.class);
    }

    public boolean isAsync() {
        return this.method.isAnnotated(Async.class);
    }

    public boolean isManagement() {
        return this.method.isAnnotated(EzyManagement.class);
    }

    public boolean isPayment() {
        return this.method.isAnnotated(EzyPayment.class);
    }

    public String getFeature() {
        EzyFeature annotation = (EzyFeature)this.method.getAnnotation(EzyFeature.class);
        return annotation != null ? annotation.value() : null;
    }

    public String toString() {
        return this.method.getName() + "(uri: " + this.requestURI + ")";
    }

    public String getRootURI() {
        return this.rootURI;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }
}

