/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.monitor;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class EzyCpuMonitor {
    protected volatile long lastProcessCpuTime;
    protected volatile long lastSystemTime = System.nanoTime();
    protected final OperatingSystemMXBean osMxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public EzyCpuMonitor() {
        this.lastProcessCpuTime = this.osMxBean.getProcessCpuTime();
    }

    public double getProcessCpuLoad() {
        long systemTime = System.nanoTime();
        long processCpuTime = this.osMxBean.getProcessCpuTime();
        long offsetSystemTime = systemTime - this.lastSystemTime;
        long offsetProcessCpuTime = processCpuTime - this.lastProcessCpuTime;
        double cpuLoad = 1.0 * (double)offsetProcessCpuTime / (double)offsetSystemTime;
        this.lastSystemTime = systemTime;
        this.lastProcessCpuTime = processCpuTime;
        int availableProcessors = this.osMxBean.getAvailableProcessors();
        return cpuLoad / (double)availableProcessors;
    }

    public double getSystemCpuLoad() {
        return this.osMxBean.getSystemCpuLoad();
    }
}

