/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.monitor.frame;

import java.text.SimpleDateFormat;

public abstract class EzyActionFrame {
    protected final long endTime;
    protected final long startTime;
    protected final long maxActions;
    protected volatile long actions;

    public EzyActionFrame(long maxActions) {
        this(maxActions, System.currentTimeMillis());
    }

    public EzyActionFrame(long maxActions, long startTime) {
        this.maxActions = maxActions;
        this.startTime = startTime;
        this.endTime = startTime + (long)this.getExistsTime();
    }

    protected abstract int getExistsTime();

    public boolean addActions(long actions) {
        return (this.actions += actions) > this.maxActions;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.endTime;
    }

    public boolean isInvalid() {
        return this.actions > this.maxActions;
    }

    public abstract EzyActionFrame nextFrame();

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss.SSS");
        return this.getClass().getSimpleName() + ": " + df.format(this.startTime) + " -> " + df.format(this.endTime);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getMaxActions() {
        return this.maxActions;
    }

    public long getActions() {
        return this.actions;
    }
}

