/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.NamedModel;

public class AdminNameModel
implements NamedModel {
    private long adminId;
    private String username;
    private String displayName;

    public static AdminNameModel fromAdminModel(AdminModel model) {
        if (model == null) {
            return null;
        }
        return AdminNameModel.builder().adminId(model.getId()).username(model.getUsername()).displayName(model.getDisplayName()).build();
    }

    @JsonIgnore
    public String getNameAndUsername() {
        return this.getName() + "<" + this.username + ">";
    }

    AdminNameModel(long adminId, String username, String displayName) {
        this.adminId = adminId;
        this.username = username;
        this.displayName = displayName;
    }

    public static AdminNameModelBuilder builder() {
        return new AdminNameModelBuilder();
    }

    public long getAdminId() {
        return this.adminId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public static class AdminNameModelBuilder {
        private long adminId;
        private String username;
        private String displayName;

        AdminNameModelBuilder() {
        }

        public AdminNameModelBuilder adminId(long adminId) {
            this.adminId = adminId;
            return this;
        }

        public AdminNameModelBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AdminNameModelBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public AdminNameModel build() {
            return new AdminNameModel(this.adminId, this.username, this.displayName);
        }

        public String toString() {
            return "AdminNameModel.AdminNameModelBuilder(adminId=" + this.adminId + ", username=" + this.username + ", displayName=" + this.displayName + ")";
        }
    }
}

