/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import java.util.Collection;
import java.util.List;
import org.youngmonkeys.ezyplatform.util.Keywords;

public class KeywordsModel {
    private String likeKeyword;
    private Collection<String> keywords;

    public static KeywordsModel extract(String value, boolean byLikeOperator) {
        String likeKeyword = null;
        List<String> keywords = null;
        if (byLikeOperator) {
            likeKeyword = value;
        } else {
            keywords = Keywords.toKeywords(value, true);
        }
        return KeywordsModel.builder().likeKeyword(likeKeyword).keywords(keywords).build();
    }

    KeywordsModel(String likeKeyword, Collection<String> keywords) {
        this.likeKeyword = likeKeyword;
        this.keywords = keywords;
    }

    public static KeywordsModelBuilder builder() {
        return new KeywordsModelBuilder();
    }

    public String getLikeKeyword() {
        return this.likeKeyword;
    }

    public Collection<String> getKeywords() {
        return this.keywords;
    }

    public static class KeywordsModelBuilder {
        private String likeKeyword;
        private Collection<String> keywords;

        KeywordsModelBuilder() {
        }

        public KeywordsModelBuilder likeKeyword(String likeKeyword) {
            this.likeKeyword = likeKeyword;
            return this;
        }

        public KeywordsModelBuilder keywords(Collection<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public KeywordsModel build() {
            return new KeywordsModel(this.likeKeyword, this.keywords);
        }

        public String toString() {
            return "KeywordsModel.KeywordsModelBuilder(likeKeyword=" + this.likeKeyword + ", keywords=" + this.keywords + ")";
        }
    }
}

