/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.reflect;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.annotation.EzyManagement;
import com.tvd12.ezyfox.annotation.EzyPayment;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyhttp.server.core.annotation.Annotations;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.TryCatch;
import com.tvd12.ezyhttp.server.core.handler.ManagementController;
import com.tvd12.ezyhttp.server.core.reflect.ExceptionHandlerMethod;
import com.tvd12.ezyhttp.server.core.reflect.RequestHandlerMethod;
import com.tvd12.ezyhttp.server.core.util.ControllerAnnotations;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControllerProxy {
    protected final EzyClass clazz;
    protected final Object instance;
    protected final String requestURI;
    protected final List<RequestHandlerMethod> requestHandlerMethods;
    protected final List<ExceptionHandlerMethod> exceptionHandlerMethods;
    protected final Map<Class<?>, ExceptionHandlerMethod> exceptionHandlerMethodMap;

    public ControllerProxy(Object instance) {
        this.instance = instance;
        this.clazz = new EzyClass(instance.getClass());
        this.requestURI = this.getRequestURI();
        this.requestHandlerMethods = this.fetchRequestHandlerMethods();
        this.exceptionHandlerMethods = this.fetchExceptionHandlerMethods();
        this.exceptionHandlerMethodMap = this.fetchExceptionHandlerMethodMap();
    }

    protected String getRequestURI() {
        return ControllerAnnotations.getURI(this.clazz.getClazz());
    }

    protected List<RequestHandlerMethod> fetchRequestHandlerMethods() {
        ArrayList<RequestHandlerMethod> list = new ArrayList<RequestHandlerMethod>();
        List methods = this.clazz.getPublicMethods(this::isRequestHandlerMethod);
        for (EzyMethod method : methods) {
            RequestHandlerMethod m = new RequestHandlerMethod(this.requestURI, method);
            list.add(m);
        }
        return list;
    }

    public boolean isManagement() {
        return this.instance instanceof ManagementController || this.isAnnotationPresent(EzyManagement.class);
    }

    public boolean isApi() {
        return this.isAnnotationPresent(Api.class);
    }

    public boolean isAuthenticated() {
        return this.isAnnotationPresent(Authenticated.class);
    }

    public boolean isPayment() {
        return this.isAnnotationPresent(EzyPayment.class);
    }

    public String getFeature() {
        EzyFeature annotation = (EzyFeature)this.clazz.getAnnotation(EzyFeature.class);
        return annotation != null ? annotation.value() : null;
    }

    public List<ExceptionHandlerMethod> fetchExceptionHandlerMethods() {
        ArrayList<ExceptionHandlerMethod> list = new ArrayList<ExceptionHandlerMethod>();
        List methods = this.clazz.getMethods(m -> m.isAnnotated(TryCatch.class));
        for (EzyMethod method : methods) {
            ExceptionHandlerMethod m2 = new ExceptionHandlerMethod(method);
            list.add(m2);
        }
        return list;
    }

    protected final Map<Class<?>, ExceptionHandlerMethod> fetchExceptionHandlerMethodMap() {
        HashMap answer = new HashMap();
        for (ExceptionHandlerMethod m : this.exceptionHandlerMethods) {
            for (Class<?> exceptionClass : m.getExceptionClasses()) {
                answer.put(exceptionClass, m);
            }
        }
        return answer;
    }

    protected boolean isRequestHandlerMethod(EzyMethod method) {
        for (Class<?> annClass : Annotations.REQUEST_HANDLER_ANNOTATIONS) {
            Annotation annotation = method.getAnnotation(annClass);
            if (annotation == null) continue;
            return true;
        }
        return false;
    }

    public String getControllerName() {
        return this.clazz.getClazz().getSimpleName();
    }

    private boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return EzyClasses.isAnnotationPresentIncludeSuper((Class)this.clazz.getClazz(), annotationClass);
    }

    public String toString() {
        return this.clazz.getName() + "(\n\tinstance: " + this.instance + ",\n\trequestHandlerMethods: " + this.requestHandlerMethods + ",\n\texceptionHandlerMethods: " + this.exceptionHandlerMethods + "\n)";
    }

    public EzyClass getClazz() {
        return this.clazz;
    }

    public Object getInstance() {
        return this.instance;
    }

    public List<RequestHandlerMethod> getRequestHandlerMethods() {
        return this.requestHandlerMethods;
    }

    public List<ExceptionHandlerMethod> getExceptionHandlerMethods() {
        return this.exceptionHandlerMethods;
    }

    public Map<Class<?>, ExceptionHandlerMethod> getExceptionHandlerMethodMap() {
        return this.exceptionHandlerMethodMap;
    }
}

