/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.view;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.util.EzyPair;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;

public class Redirect {
    private final String uri;
    private final List<Cookie> cookies;
    private final Map<String, String> headers;
    private final Map<String, Object> attributes;
    private final List<EzyPair<String, Object>> parameters;

    protected Redirect(Builder builder) {
        this.uri = builder.uri;
        this.cookies = builder.cookies;
        this.headers = builder.headers;
        this.parameters = builder.parameters;
        this.attributes = builder.attributes;
    }

    public static Redirect to(String uri) {
        return Redirect.builder().uri(uri).build();
    }

    public String getQueryString() throws IOException {
        if (this.parameters.isEmpty()) {
            return "";
        }
        int concatChar = 63;
        StringBuilder builder = new StringBuilder();
        for (EzyPair<String, Object> pair : this.parameters) {
            builder.append((char)concatChar).append((String)pair.getKey()).append("=").append(URLEncoder.encode(pair.getValue().toString(), "UTF-8"));
            concatChar = 38;
        }
        return builder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUri() {
        return this.uri;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static class Builder
    implements EzyBuilder<Redirect> {
        private String uri;
        private List<Cookie> cookies;
        private Map<String, String> headers;
        private Map<String, Object> attributes;
        private List<EzyPair<String, Object>> parameters;

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder addHeader(String name, Object value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value.toString());
            return this;
        }

        public Builder addHeaders(Map<String, Object> headers) {
            for (Map.Entry<String, Object> e : headers.entrySet()) {
                this.addHeader(e.getKey(), e.getValue());
            }
            return this;
        }

        public Builder addAttribute(String name, Object value) {
            this.preAddAttributes();
            this.attributes.put(name, value);
            return this;
        }

        public Builder addAttributes(Map<String, Object> attributes) {
            this.preAddAttributes();
            this.attributes.putAll(attributes);
            return this;
        }

        private void preAddAttributes() {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
        }

        public Builder addParameters(Map<String, Object> parameters) {
            for (Map.Entry<String, Object> e : parameters.entrySet()) {
                this.addParameter(e.getKey(), e.getValue());
            }
            return this;
        }

        public Builder addParameter(String name, Object value) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<EzyPair<String, Object>>();
            }
            this.parameters.add((EzyPair<String, Object>)new EzyPair((Object)name, value));
            return this;
        }

        public Builder addCookie(Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<Cookie>();
            }
            this.cookies.add(cookie);
            return this;
        }

        public Builder addCookie(String name, Object value) {
            return this.addCookie(new Cookie(name, value.toString()));
        }

        public Builder addCookie(String name, Object value, String path) {
            Cookie cookie = new Cookie(name, value.toString());
            cookie.setPath(path);
            return this.addCookie(cookie);
        }

        public Redirect build() {
            if (this.cookies == null) {
                this.cookies = Collections.emptyList();
            }
            if (this.headers == null) {
                this.headers = Collections.emptyMap();
            }
            if (this.parameters == null) {
                this.parameters = Collections.emptyList();
            }
            return new Redirect(this);
        }
    }
}

