/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.config;

import com.tvd12.ezyhttp.server.core.view.MessageProvider;
import com.tvd12.ezyhttp.server.core.view.MessageReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;

public abstract class AbstractMessageProvider
implements MessageProvider {
    private final FileSystemManager fileSystemManager;
    private static final String MESSAGES_FOLDER = "resources/messages";

    public Map<String, Properties> provide() {
        String ezyplatformHomePath = this.fileSystemManager.getEzyHomePathString();
        HashMap<String, Properties> answer = new HashMap<String, Properties>();
        TargetType targetType = this.getInclusiveTargetType();
        this.readAndAppendMessages(answer, Paths.get(ezyplatformHomePath, targetType.getName(), MESSAGES_FOLDER));
        ModuleType[] moduleTypes = this.getInclusiveModuleTypes();
        Map<ModuleType, List<String>> modulesMap = this.getInclusiveModulesMapByModuleTypes(moduleTypes);
        for (ModuleType moduleType : moduleTypes) {
            List modules = modulesMap.getOrDefault(moduleType, Collections.emptyList());
            for (String module : modules) {
                this.readAndAppendMessages(answer, Paths.get(ezyplatformHomePath, moduleType.getTargetFolder(), module, MESSAGES_FOLDER));
            }
        }
        return answer;
    }

    private void readAndAppendMessages(Map<String, Properties> messages, Path messageFolder) {
        if (!Files.exists(messageFolder, new LinkOption[0])) {
            return;
        }
        MessageReader messageReader = MessageReader.getDefault();
        Map map = messageReader.read(messageFolder.toString());
        for (Map.Entry e : map.entrySet()) {
            String lang = (String)e.getKey();
            messages.computeIfAbsent(lang, k -> new Properties()).putAll((Map<?, ?>)((Map)e.getValue()));
        }
    }

    protected abstract TargetType getInclusiveTargetType();

    protected abstract ModuleType[] getInclusiveModuleTypes();

    protected abstract Map<ModuleType, List<String>> getInclusiveModulesMapByModuleTypes(ModuleType[] var1);

    public AbstractMessageProvider(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }
}

