/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.controller.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.stream.EzyInputStreamLoader;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyReturner;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.data.DownloadFileResult;
import com.tvd12.ezyhttp.core.exception.HttpNotAcceptableException;
import com.tvd12.ezyhttp.core.resources.ResourceDownloadManager;
import com.tvd12.ezyhttp.server.core.handler.ResourceRequestHandler;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.resources.FileUploader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.youngmonkeys.ezyplatform.converter.HttpModelToResponseConverter;
import org.youngmonkeys.ezyplatform.converter.HttpRequestToModelConverter;
import org.youngmonkeys.ezyplatform.data.FileMetadata;
import org.youngmonkeys.ezyplatform.data.ImageSize;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;
import org.youngmonkeys.ezyplatform.event.EventHandlerManager;
import org.youngmonkeys.ezyplatform.event.GetMediaFilePathEvent;
import org.youngmonkeys.ezyplatform.event.MediaAddedEvent;
import org.youngmonkeys.ezyplatform.event.MediaDownloadEvent;
import org.youngmonkeys.ezyplatform.event.MediaRemovedEvent;
import org.youngmonkeys.ezyplatform.event.MediaUpdatedEvent;
import org.youngmonkeys.ezyplatform.event.MediaUploadEvent;
import org.youngmonkeys.ezyplatform.event.MediaUploadedEvent;
import org.youngmonkeys.ezyplatform.exception.MediaNotFoundException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.model.AddMediaModel;
import org.youngmonkeys.ezyplatform.model.MediaDetailsModel;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.UpdateMediaModel;
import org.youngmonkeys.ezyplatform.pagination.DefaultMediaFilter;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;
import org.youngmonkeys.ezyplatform.pagination.PaginationModelFetchers;
import org.youngmonkeys.ezyplatform.request.AddMediaFromUrlRequest;
import org.youngmonkeys.ezyplatform.request.UpdateMediaIncludeUrlRequest;
import org.youngmonkeys.ezyplatform.request.UpdateMediaRequest;
import org.youngmonkeys.ezyplatform.response.MediaResponse;
import org.youngmonkeys.ezyplatform.service.MediaService;
import org.youngmonkeys.ezyplatform.service.PaginationMediaService;
import org.youngmonkeys.ezyplatform.service.PaginationService;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.util.Uris;
import org.youngmonkeys.ezyplatform.validator.CommonValidator;
import org.youngmonkeys.ezyplatform.validator.MediaValidator;

public class MediaControllerService
extends EzyLoggable {
    private final HttpClient httpClient;
    private final EventHandlerManager eventHandlerManager;
    private final FileSystemManager fileSystemManager;
    private final ResourceDownloadManager resourceDownloadManager;
    private final MediaService mediaService;
    private final PaginationMediaService paginationMediaService;
    private final SettingService settingService;
    private final CommonValidator commonValidator;
    private final MediaValidator mediaValidator;
    private final HttpRequestToModelConverter requestToModelConverter;
    private final HttpModelToResponseConverter modelToResponseConverter;
    private final EzyLazyInitializer<FileUploader> fileUploaderWrapper;
    private final EzyInputStreamLoader inputStreamLoader;
    private final ObjectMapper objectMapper;
    private final EzyLazyInitializer<TikaConfig> tika = new EzyLazyInitializer(() -> (TikaConfig)EzyReturner.returnWithException(TikaConfig::new));

    public MediaControllerService(HttpClient httpClient, EventHandlerManager eventHandlerManager, FileSystemManager fileSystemManager, ResourceDownloadManager resourceDownloadManager, MediaService mediaService, PaginationMediaService paginationMediaService, SettingService settingService, CommonValidator commonValidator, MediaValidator mediaValidator, HttpRequestToModelConverter requestToModelConverter, HttpModelToResponseConverter modelToResponseConverter, EzySingletonFactory singletonFactory, EzyInputStreamLoader inputStreamLoader, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.mediaService = mediaService;
        this.paginationMediaService = paginationMediaService;
        this.settingService = settingService;
        this.objectMapper = objectMapper;
        this.inputStreamLoader = inputStreamLoader;
        this.commonValidator = commonValidator;
        this.mediaValidator = mediaValidator;
        this.eventHandlerManager = eventHandlerManager;
        this.fileSystemManager = fileSystemManager;
        this.resourceDownloadManager = resourceDownloadManager;
        this.requestToModelConverter = requestToModelConverter;
        this.modelToResponseConverter = modelToResponseConverter;
        this.fileUploaderWrapper = new EzyLazyInitializer(() -> (FileUploader)singletonFactory.getSingletonCast(FileUploader.class));
    }

    public void addMedia(HttpServletRequest request, HttpServletResponse response, UploadFrom uploadFrom, long ownerId, boolean avatar, boolean notPublic) throws Exception {
        Collection parts;
        FileUploader fileUploader = (FileUploader)this.fileUploaderWrapper.get();
        if (fileUploader == null) {
            throw new HttpNotAcceptableException(Collections.singletonMap("fileUpload", "disabled"));
        }
        Part filePart = request.getPart("file");
        if (filePart == null && !(parts = request.getParts()).isEmpty()) {
            filePart = (Part)parts.iterator().next();
        }
        FileMetadata fileMetadata = this.mediaValidator.validateFilePart(filePart, avatar);
        this.eventHandlerManager.handleEvent((Object)new MediaUploadEvent(uploadFrom, ownerId, fileMetadata));
        String submittedFileName = filePart.getSubmittedFileName();
        String fileExtension = fileMetadata.getExtension();
        String containerFolder = fileMetadata.getMediaType().getFolder();
        String newFileName = this.mediaService.generateMediaFileName(submittedFileName, fileExtension);
        AsyncContext asyncContext = request.getAsyncContext();
        File mediaFilePath = this.fileSystemManager.getMediaFilePath(containerFolder, newFileName);
        fileUploader.accept(asyncContext, filePart, mediaFilePath, this.settingService.getMaxUploadFileSize(), () -> {
            MediaModel model = this.saveMediaInformation(uploadFrom, ownerId, submittedFileName, newFileName, fileMetadata, notPublic);
            this.notifyMediaEvent(new MediaUploadedEvent(model, mediaFilePath));
            byte[] responseBytes = this.mediaAddResponse(model).getBytes();
            response.getOutputStream().write(responseBytes);
        });
    }

    public MediaModel addMedia(long ownerId, AddMediaFromUrlRequest request, boolean notPublic, UploadFrom uploadFrom) {
        this.mediaValidator.validate(request);
        String mediaName = this.mediaService.generateMediaFileName(request.getUrl(), request.getType().toString().toLowerCase());
        AddMediaModel model = this.requestToModelConverter.toModel(ownerId, mediaName, request, notPublic);
        MediaModel media = this.mediaService.addMedia(model, uploadFrom);
        this.notifyMediaEvent(new MediaAddedEvent(media.getId()));
        return media;
    }

    public void updateMedia(long mediaId, UpdateMediaRequest request) {
        this.mediaValidator.validate(request);
        UpdateMediaModel model = this.requestToModelConverter.toModel(mediaId, request);
        this.mediaService.updateMedia(model);
        this.notifyMediaEvent(new MediaUpdatedEvent(model.getMediaId()));
    }

    public void updateMedia(long mediaId, UpdateMediaIncludeUrlRequest request) {
        this.mediaValidator.validate(request);
        UpdateMediaModel model = this.requestToModelConverter.toModel(mediaId, request);
        this.mediaService.updateMedia(model);
        this.notifyMediaEvent(new MediaUpdatedEvent(model.getMediaId()));
    }

    public void updateMedia(long ownerId, String mediaName, UpdateMediaRequest request) {
        this.mediaValidator.validate(request);
        UpdateMediaModel model = this.requestToModelConverter.toModel(mediaName, request);
        this.mediaService.updateMedia(ownerId, model);
        this.notifyMediaEvent(new MediaUpdatedEvent(model.getMediaId()));
    }

    public void removeMedia(long mediaId) {
        MediaModel media = this.mediaService.removeMedia(mediaId);
        File file = this.fileSystemManager.getMediaFilePath(media.getType().getFolder(), media.getName());
        FolderProxy.deleteFile((File)file);
        this.notifyMediaEvent(new MediaRemovedEvent(media));
    }

    public void removeMedia(long ownerId, String mediaName, boolean deleteFile) {
        MediaModel media = this.mediaService.removeMedia(ownerId, mediaName);
        if (deleteFile) {
            String containerFolder = media.getType().getFolder();
            File filePath = this.fileSystemManager.getMediaFilePath(containerFolder, media.getName());
            FolderProxy.deleteFile((File)filePath);
            this.notifyMediaEvent(new MediaRemovedEvent(media));
        }
    }

    public long saveMediaFile(MediaType mediaType, String mediaUrl, UploadFrom from, long ownerAdminId, long ownerUserId) {
        if (EzyStrings.isBlank((String)mediaUrl)) {
            return 0L;
        }
        try {
            org.apache.tika.mime.MediaType tikaMediaType;
            File outFolder = this.fileSystemManager.getMediaFolderPath(mediaType);
            String fileName = this.mediaService.generateMediaFileName(mediaUrl, Uris.getFileExtensionInUrl((String)mediaUrl));
            DownloadFileResult result = this.httpClient.download(mediaUrl, outFolder, fileName);
            try (InputStream inputStream = Files.newInputStream(outFolder.toPath().resolve(result.getNewFileName()), new OpenOption[0]);){
                tikaMediaType = ((TikaConfig)this.tika.get()).getDetector().detect((InputStream)TikaInputStream.get((InputStream)inputStream), new Metadata());
            }
            MediaModel media = this.mediaService.addMedia(AddMediaModel.builder().fileName(result.getNewFileName()).originalFileName(result.getOriginalFileName()).mediaType(mediaType).mimeType(tikaMediaType.toString()).ownerId(ownerAdminId > 0L ? ownerAdminId : ownerUserId).build(), from);
            return media.getId();
        }
        catch (Exception e) {
            this.logger.info("can not download media from url: {}", (Object)mediaUrl, (Object)e);
            return 0L;
        }
    }

    public void getMedia(RequestArguments requestArguments, String name) throws Exception {
        this.getMedia(requestArguments, name, true);
    }

    public void getMedia(RequestArguments requestArguments, String name, boolean exposePrivateMedia) throws Exception {
        this.getMedia(requestArguments, name, exposePrivateMedia, media -> true);
    }

    public void getMedia(RequestArguments requestArguments, String name, boolean exposePrivateMedia, Predicate<MediaModel> validMediaCondition) throws Exception {
        this.mediaValidator.validateMediaName(name);
        MediaModel media = this.mediaService.getMediaByName(name);
        if (media == null || !media.isPublicMedia() && !exposePrivateMedia && !validMediaCondition.test(media)) {
            throw new MediaNotFoundException(name);
        }
        this.notifyMediaEvent(new MediaDownloadEvent(media));
        MediaType mediaType = media.getType();
        File resourcePath = this.fileSystemManager.getMediaFilePath(mediaType.getFolder(), name);
        if (!resourcePath.exists()) {
            throw new MediaNotFoundException(name);
        }
        String extension = FolderProxy.getFileExtension((String)name);
        ResourceRequestHandler handler = new ResourceRequestHandler(resourcePath.toString(), resourcePath.toString(), extension, this.inputStreamLoader, this.resourceDownloadManager);
        handler.handle(requestArguments);
    }

    public MediaDetailsModel getMediaDetails(long mediaId) throws IOException {
        MediaModel media = this.mediaService.getMediaById(mediaId);
        if (media == null) {
            throw new MediaNotFoundException(mediaId);
        }
        return this.getMediaDetails(media);
    }

    public MediaDetailsModel getMediaDetails(long ownerId, String mediaName) throws IOException {
        MediaModel media = this.mediaService.getMediaByName(mediaName);
        if (media == null || media.getOwnerUserId() != ownerId) {
            throw new MediaNotFoundException(mediaName);
        }
        return this.getMediaDetails(media);
    }

    public MediaDetailsModel getMediaDetails(MediaModel media) throws IOException {
        long size;
        int width = 0;
        int height = 0;
        MediaType mediaType = media.getType();
        if (mediaType == MediaType.IMAGE || mediaType == MediaType.AVATAR) {
            File mediaFilePath;
            ImageSize imageSize = this.mediaService.getMediaImageSizeOrNull(media.getName(), media.getType());
            if (imageSize == null && (mediaFilePath = (File)this.eventHandlerManager.handleEvent((Object)new GetMediaFilePathEvent(media))) != null) {
                imageSize = this.mediaService.getMediaImageSizeOrDefault(mediaFilePath);
            }
            if (imageSize == null) {
                imageSize = ImageSize.ZERO;
            }
            width = imageSize.getWidth();
            height = imageSize.getHeight();
            size = imageSize.getSize();
        } else {
            File mediaFilePath;
            size = this.mediaService.getMediaFileLengthOrNegative(mediaType, media.getName());
            if (size < 0L && (mediaFilePath = (File)this.eventHandlerManager.handleEvent((Object)new GetMediaFilePathEvent(media))) != null) {
                size = this.mediaService.getMediaFileLengthOrZero(mediaFilePath);
            }
        }
        if (size < 0L) {
            size = 0L;
        }
        return MediaDetailsModel.from((MediaModel)media).width((long)width).height((long)height).size(size).build();
    }

    public MediaModel getMediaById(long mediaId) {
        return this.mediaService.getMediaById(mediaId);
    }

    public MediaModel getMediaByName(String name) {
        return this.mediaService.getMediaByName(name);
    }

    public PaginationModel<MediaResponse> getMediaList(String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        this.commonValidator.validatePageSize(limit);
        PaginationModel pagination = PaginationModelFetchers.getPaginationModel((PaginationService)this.paginationMediaService, (String)nextPageToken, (String)prevPageToken, (boolean)lastPage, (int)limit);
        return pagination.map(this.modelToResponseConverter::toResponse);
    }

    public PaginationModel<MediaResponse> getMediaList(MediaFilter filter, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        this.commonValidator.validatePageSize(limit);
        PaginationModel pagination = PaginationModelFetchers.getPaginationModel((PaginationService)this.paginationMediaService, (Object)filter, (String)nextPageToken, (String)prevPageToken, (boolean)lastPage, (int)limit);
        return pagination.map(this.modelToResponseConverter::toResponse);
    }

    public PaginationModel<MediaResponse> getMediaList(long ownerUserId, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        return this.getMediaList(((DefaultMediaFilter.Builder)DefaultMediaFilter.builder().ownerUserId(ownerUserId)).build(), nextPageToken, prevPageToken, lastPage, limit);
    }

    public PaginationModel<MediaResponse> getAdminMediaList(long ownerAdminId, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        return this.getMediaList(((DefaultMediaFilter.Builder)DefaultMediaFilter.builder().ownerAdminId(ownerAdminId)).build(), nextPageToken, prevPageToken, lastPage, limit);
    }

    private MediaModel saveMediaInformation(UploadFrom uploadFrom, long ownerId, String submittedFileName, String fileName, FileMetadata fileMetadata, boolean notPublic) {
        return this.mediaService.addMedia(AddMediaModel.builder().ownerId(ownerId).fileName(fileName).originalFileName(submittedFileName).mediaType(fileMetadata.getMediaType()).mimeType(fileMetadata.getMimeType()).notPublic(notPublic).build(), uploadFrom);
    }

    public List<MediaModel> getMediaListByIds(Collection<Long> mediaIds) {
        return this.mediaService.getMediaListByIds(mediaIds);
    }

    public Map<Long, MediaModel> getMediaMapByIds(Collection<Long> mediaIds) {
        return this.mediaService.getMediaMapByIds(mediaIds);
    }

    private String mediaAddResponse(MediaModel model) throws IOException {
        return this.objectMapper.writeValueAsString((Object)model);
    }

    protected void notifyMediaEvent(Object event) {
        try {
            this.eventHandlerManager.handleEvent(event);
        }
        catch (Throwable e) {
            this.logger.warn("notify media event: {} failed", (Object)event.getClass().getSimpleName(), (Object)e);
        }
    }
}

