/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver;

import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyStartable;
import com.tvd12.ezyfoxserver.EzyBootstrap;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.config.EzyConfig;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.event.EzySimpleServerReadyEvent;
import com.tvd12.ezyfoxserver.setting.EzyHttpSetting;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.setting.EzySocketSetting;
import com.tvd12.ezyfoxserver.setting.EzyThreadPoolSizeSetting;
import com.tvd12.ezyfoxserver.setting.EzyUdpSetting;
import com.tvd12.ezyfoxserver.setting.EzyWebSocketSetting;
import com.tvd12.ezyfoxserver.util.EzyBannerPrinter;

public abstract class EzyServerBootstrap
extends EzyLoggable
implements EzyStartable,
EzyDestroyable {
    protected EzyServerContext context;
    protected EzyBootstrap localBootstrap;

    public void start() throws Exception {
        this.setupServer();
        this.startLocalBootstrap();
        this.startHttpBootstrap();
        this.startOtherBootstraps(this::notifyServerReady);
    }

    protected void setupServer() {
    }

    protected void startHttpBootstrap() throws Exception {
    }

    protected abstract void startOtherBootstraps(Runnable var1) throws Exception;

    public void destroy() {
        EzyProcessor.processWithLogException(() -> this.localBootstrap.destroy());
    }

    protected void startLocalBootstrap() throws Exception {
        this.logger.debug("starting local bootstrap ....");
        this.localBootstrap.start();
        this.logger.debug("local bootstrap has started");
    }

    protected final void notifyServerReady() {
        this.printBanner();
        this.doNotifyServerReady();
    }

    protected final void printBanner() {
        if (this.getServerConfig().isPrintBanner()) {
            String bannerFile = this.getServerConfig().getBannerFile();
            this.logger.info("\n{}\n", (Object)new EzyBannerPrinter().getBannerText(bannerFile));
        }
    }

    protected void doNotifyServerReady() {
        EzySimpleServerReadyEvent event = new EzySimpleServerReadyEvent();
        this.context.handleEvent(EzyEventType.SERVER_READY, event);
        this.context.broadcast(EzyEventType.SERVER_READY, event, true);
    }

    protected EzyServer getServer() {
        return this.context.getServer();
    }

    protected EzyConfig getServerConfig() {
        return this.getServer().getConfig();
    }

    protected EzySettings getServerSettings() {
        return this.getServer().getSettings();
    }

    protected EzyHttpSetting getHttpSetting() {
        return this.getServerSettings().getHttp();
    }

    protected EzySocketSetting getSocketSetting() {
        return this.getServerSettings().getSocket();
    }

    protected EzyUdpSetting getUdpSetting() {
        return this.getServerSettings().getUdp();
    }

    protected EzyWebSocketSetting getWebSocketSetting() {
        return this.getServerSettings().getWebsocket();
    }

    protected EzyThreadPoolSizeSetting getThreadPoolSizeSetting() {
        return this.getServerSettings().getThreadPoolSize();
    }

    public void setContext(EzyServerContext context) {
        this.context = context;
    }

    public void setLocalBootstrap(EzyBootstrap localBootstrap) {
        this.localBootstrap = localBootstrap;
    }

    public EzyServerContext getContext() {
        return this.context;
    }
}

