/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.delegate;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.context.EzyAppContextAware;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.delegate.EzyAppUserDelegate;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.event.EzySimpleUserRemovedEvent;
import com.tvd12.ezyfoxserver.response.EzyExitedAppParams;
import com.tvd12.ezyfoxserver.response.EzyExitedAppResponse;
import com.tvd12.ezyfoxserver.response.EzyResponse;
import com.tvd12.ezyfoxserver.setting.EzyAppSetting;

public class EzySimpleAppUserDelegate
extends EzyLoggable
implements EzyAppUserDelegate,
EzyAppContextAware,
EzyDestroyable {
    protected EzyAppContext appContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUserRemoved(EzyUser user, EzyConstant reason) {
        try {
            this.handleUserRemovedEvent(user, reason);
        }
        catch (Exception e) {
            this.logger.warn("handle user {} error", (Object)user, (Object)e);
        }
        finally {
            this.responseUserRemoved(user, reason);
        }
    }

    protected void handleUserRemovedEvent(EzyUser user, EzyConstant reason) {
        EzySimpleUserRemovedEvent event = new EzySimpleUserRemovedEvent(user, reason);
        this.appContext.handleEvent(EzyEventType.USER_REMOVED, event);
    }

    protected void responseUserRemoved(EzyUser user, EzyConstant reason) {
        EzyResponse response = this.newExitedAppResponse(reason);
        EzyZoneContext zoneContext = this.appContext.getParent();
        zoneContext.send(response, user, false);
    }

    protected EzyResponse newExitedAppResponse(EzyConstant reason) {
        EzyExitedAppParams params = new EzyExitedAppParams();
        EzyAppSetting appSetting = this.appContext.getApp().getSetting();
        params.setApp(appSetting);
        params.setReason(reason);
        return new EzyExitedAppResponse(params);
    }

    public void destroy() {
        this.appContext = null;
    }

    @Override
    public void setAppContext(EzyAppContext appContext) {
        this.appContext = appContext;
    }
}

