/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.entity;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.entity.EzyEntity;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.delegate.EzySessionDelegate;
import com.tvd12.ezyfoxserver.entity.EzyDisconnectReasonAware;
import com.tvd12.ezyfoxserver.entity.EzyDroppedPackets;
import com.tvd12.ezyfoxserver.entity.EzyDroppedPacketsAware;
import com.tvd12.ezyfoxserver.entity.EzyImmediateDeliver;
import com.tvd12.ezyfoxserver.entity.EzyImmediateDeliverAware;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import com.tvd12.ezyfoxserver.socket.EzyDatagramChannelAware;
import com.tvd12.ezyfoxserver.socket.EzyDatagramChannelPool;
import com.tvd12.ezyfoxserver.socket.EzyDatagramChannelPoolAware;
import com.tvd12.ezyfoxserver.socket.EzyPacket;
import com.tvd12.ezyfoxserver.socket.EzyPacketQueue;
import com.tvd12.ezyfoxserver.socket.EzyRequestQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsQueue;
import com.tvd12.ezyfoxserver.socket.EzySimpleSocketDisconnection;
import com.tvd12.ezyfoxserver.socket.EzySocketDisconnectionQueue;
import com.tvd12.ezyfoxserver.socket.EzyUdpClientAddressAware;
import com.tvd12.ezyfoxserver.statistics.EzyRequestFrame;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;

public abstract class EzyAbstractSession
extends EzyEntity
implements EzySession,
EzyDisconnectReasonAware,
EzyDatagramChannelAware,
EzyUdpClientAddressAware,
EzyImmediateDeliverAware,
EzyDroppedPacketsAware,
EzyDatagramChannelPoolAware {
    private static final long serialVersionUID = -4112736666616219904L;
    protected long id;
    protected String name;
    protected String clientId;
    protected String ownerName;
    protected long creationTime;
    protected long lastReadTime;
    protected long lastWriteTime;
    protected long readBytes;
    protected long writtenBytes;
    protected long lastActivityTime;
    protected long loggedInTime;
    protected int readRequests;
    protected int writtenResponses;
    protected byte[] privateKey;
    protected byte[] publicKey;
    protected byte[] clientKey;
    protected byte[] sessionKey;
    protected volatile boolean loggedIn;
    protected volatile boolean activated;
    protected volatile boolean destroyed;
    protected volatile boolean streamingEnable;
    protected String token;
    protected String clientType;
    protected String clientVersion;
    protected String beforeToken;
    protected EzyConstant connectionType;
    protected EzyConstant disconnectReason;
    protected SocketAddress udpClientAddress;
    protected DatagramChannel datagramChannel;
    protected EzyDatagramChannelPool datagramChannelPool;
    protected long maxWaitingTime = 5000L;
    protected long maxIdleTime = 180000L;
    protected EzyChannel channel;
    protected EzyDroppedPackets droppedPackets;
    protected EzyImmediateDeliver immediateDeliver;
    protected EzySessionTicketsQueue sessionTicketsQueue;
    protected EzySocketDisconnectionQueue disconnectionQueue;
    protected EzyPacketQueue packetQueue;
    protected EzyRequestQueue systemRequestQueue;
    protected EzyRequestQueue extensionRequestQueue;
    protected EzyRequestFrame requestFrameInSecond;
    protected transient EzySessionDelegate delegate;
    protected volatile boolean disconnectionRegistered;
    protected final Object disconnectionLock = new Object();

    public void setOwner(EzyUser owner) {
        this.ownerName = owner.getName();
        this.delegate.onSessionLoggedIn(owner);
    }

    @Override
    public void addReadBytes(long bytes) {
        this.readBytes += bytes;
    }

    @Override
    public void addWrittenBytes(long bytes) {
        this.writtenBytes += bytes;
    }

    @Override
    public void addReadRequests(int requests) {
        this.readRequests += requests;
    }

    @Override
    public boolean addReceivedRequests(int requests) {
        if (this.requestFrameInSecond.isExpired()) {
            this.requestFrameInSecond = this.requestFrameInSecond.nextFrame();
        }
        return this.requestFrameInSecond.addRequests(requests);
    }

    @Override
    public void addWrittenResponses(int responses) {
        this.writtenResponses += responses;
    }

    @Override
    public void setActivated(boolean value) {
        this.activated = value;
    }

    @Override
    public boolean isIdle() {
        if (this.loggedIn) {
            long offset = System.currentTimeMillis() - this.lastReadTime;
            return this.maxIdleTime < offset;
        }
        return false;
    }

    @Override
    public final void send(EzyPacket packet) {
        if (this.activated) {
            this.addWrittenResponses(1);
            this.setLastWriteTime(System.currentTimeMillis());
            this.setLastActivityTime(System.currentTimeMillis());
            this.addPacketToSessionQueue(packet);
        }
    }

    @Override
    public void sendNow(EzyPacket packet) {
        this.immediateDeliver.sendPacketNow(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPacketToSessionQueue(EzyPacket packet) {
        boolean success;
        EzyPacketQueue ezyPacketQueue = this.packetQueue;
        synchronized (ezyPacketQueue) {
            EzySessionTicketsQueue ticketsQueue;
            boolean empty = this.packetQueue.isEmpty();
            success = this.packetQueue.add(packet);
            if (success && empty && (ticketsQueue = this.sessionTicketsQueue) != null) {
                this.sessionTicketsQueue.add(this);
            }
        }
        if (!success) {
            EzyDroppedPackets droppedPacketsNow = this.droppedPackets;
            if (droppedPacketsNow != null) {
                this.droppedPackets.addDroppedPacket(packet);
            }
            packet.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(EzyConstant disconnectReason) {
        Object object = this.disconnectionLock;
        synchronized (object) {
            if (!this.disconnectionRegistered) {
                this.disconnectReason = disconnectReason;
                EzySocketDisconnectionQueue queue = this.disconnectionQueue;
                if (queue != null) {
                    queue.add(new EzySimpleSocketDisconnection(this, disconnectReason));
                }
                this.disconnectionRegistered = true;
            }
        }
    }

    @Override
    public void close() {
        EzyProcessor.processWithLogException(() -> this.channel.close());
    }

    @Override
    public <T> T getConnection() {
        return this.channel != null ? (T)this.channel.getConnection() : null;
    }

    @Override
    public SocketAddress getServerAddress() {
        return this.channel != null ? this.channel.getServerAddress() : null;
    }

    @Override
    public SocketAddress getClientAddress() {
        return this.channel != null ? this.channel.getClientAddress() : null;
    }

    public String getName() {
        return this.name + "(owner: " + this.ownerName + ", address: " + this.getClientAddress() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object;
        this.destroyed = true;
        this.activated = false;
        this.channel = null;
        this.delegate = null;
        this.loggedIn = false;
        this.readBytes = 0L;
        this.writtenBytes = 0L;
        this.connectionType = null;
        this.properties.clear();
        this.droppedPackets = null;
        this.immediateDeliver = null;
        if (this.packetQueue != null) {
            object = this.packetQueue;
            synchronized (object) {
                this.packetQueue.clear();
            }
        }
        if (this.systemRequestQueue != null) {
            object = this.systemRequestQueue;
            synchronized (object) {
                this.systemRequestQueue.clear();
            }
        }
        if (this.extensionRequestQueue != null) {
            object = this.extensionRequestQueue;
            synchronized (object) {
                this.extensionRequestQueue.clear();
            }
        }
        this.sessionTicketsQueue = null;
        this.disconnectionQueue = null;
        this.udpClientAddress = null;
        this.datagramChannel = null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof EzyAbstractSession) {
            return this.id == ((EzyAbstractSession)obj).id;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "(id: " + this.id + ", type: " + this.clientType + ", version: " + this.clientVersion + ", address: " + this.getClientAddress() + ", token: " + this.token + ")";
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    @Override
    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    @Override
    public long getLoggedInTime() {
        return this.loggedInTime;
    }

    @Override
    public int getReadRequests() {
        return this.readRequests;
    }

    @Override
    public int getWrittenResponses() {
        return this.writtenResponses;
    }

    @Override
    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Override
    public byte[] getClientKey() {
        return this.clientKey;
    }

    @Override
    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isStreamingEnable() {
        return this.streamingEnable;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getClientType() {
        return this.clientType;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public String getBeforeToken() {
        return this.beforeToken;
    }

    @Override
    public EzyConstant getConnectionType() {
        return this.connectionType;
    }

    @Override
    public EzyConstant getDisconnectReason() {
        return this.disconnectReason;
    }

    @Override
    public SocketAddress getUdpClientAddress() {
        return this.udpClientAddress;
    }

    @Override
    public DatagramChannel getDatagramChannel() {
        return this.datagramChannel;
    }

    @Override
    public EzyDatagramChannelPool getDatagramChannelPool() {
        return this.datagramChannelPool;
    }

    @Override
    public long getMaxWaitingTime() {
        return this.maxWaitingTime;
    }

    @Override
    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public EzyChannel getChannel() {
        return this.channel;
    }

    public EzyDroppedPackets getDroppedPackets() {
        return this.droppedPackets;
    }

    public EzyImmediateDeliver getImmediateDeliver() {
        return this.immediateDeliver;
    }

    public EzySessionTicketsQueue getSessionTicketsQueue() {
        return this.sessionTicketsQueue;
    }

    public EzySocketDisconnectionQueue getDisconnectionQueue() {
        return this.disconnectionQueue;
    }

    @Override
    public EzyPacketQueue getPacketQueue() {
        return this.packetQueue;
    }

    @Override
    public EzyRequestQueue getSystemRequestQueue() {
        return this.systemRequestQueue;
    }

    @Override
    public EzyRequestQueue getExtensionRequestQueue() {
        return this.extensionRequestQueue;
    }

    public EzyRequestFrame getRequestFrameInSecond() {
        return this.requestFrameInSecond;
    }

    public EzySessionDelegate getDelegate() {
        return this.delegate;
    }

    public boolean isDisconnectionRegistered() {
        return this.disconnectionRegistered;
    }

    public Object getDisconnectionLock() {
        return this.disconnectionLock;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public void setLastReadTime(long lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    @Override
    public void setLastWriteTime(long lastWriteTime) {
        this.lastWriteTime = lastWriteTime;
    }

    @Override
    public void setLastActivityTime(long lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
    }

    @Override
    public void setLoggedInTime(long loggedInTime) {
        this.loggedInTime = loggedInTime;
    }

    public void setReadRequests(int readRequests) {
        this.readRequests = readRequests;
    }

    public void setWrittenResponses(int writtenResponses) {
        this.writtenResponses = writtenResponses;
    }

    @Override
    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public void setClientKey(byte[] clientKey) {
        this.clientKey = clientKey;
    }

    @Override
    public void setSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Override
    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public void setStreamingEnable(boolean streamingEnable) {
        this.streamingEnable = streamingEnable;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    @Override
    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public void setBeforeToken(String beforeToken) {
        this.beforeToken = beforeToken;
    }

    public void setConnectionType(EzyConstant connectionType) {
        this.connectionType = connectionType;
    }

    @Override
    public void setDisconnectReason(EzyConstant disconnectReason) {
        this.disconnectReason = disconnectReason;
    }

    @Override
    public void setUdpClientAddress(SocketAddress udpClientAddress) {
        this.udpClientAddress = udpClientAddress;
    }

    @Override
    public void setDatagramChannel(DatagramChannel datagramChannel) {
        this.datagramChannel = datagramChannel;
    }

    @Override
    public void setDatagramChannelPool(EzyDatagramChannelPool datagramChannelPool) {
        this.datagramChannelPool = datagramChannelPool;
    }

    @Override
    public void setMaxWaitingTime(long maxWaitingTime) {
        this.maxWaitingTime = maxWaitingTime;
    }

    @Override
    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public void setChannel(EzyChannel channel) {
        this.channel = channel;
    }

    @Override
    public void setDroppedPackets(EzyDroppedPackets droppedPackets) {
        this.droppedPackets = droppedPackets;
    }

    @Override
    public void setImmediateDeliver(EzyImmediateDeliver immediateDeliver) {
        this.immediateDeliver = immediateDeliver;
    }

    public void setSessionTicketsQueue(EzySessionTicketsQueue sessionTicketsQueue) {
        this.sessionTicketsQueue = sessionTicketsQueue;
    }

    public void setDisconnectionQueue(EzySocketDisconnectionQueue disconnectionQueue) {
        this.disconnectionQueue = disconnectionQueue;
    }

    public void setPacketQueue(EzyPacketQueue packetQueue) {
        this.packetQueue = packetQueue;
    }

    public void setSystemRequestQueue(EzyRequestQueue systemRequestQueue) {
        this.systemRequestQueue = systemRequestQueue;
    }

    public void setExtensionRequestQueue(EzyRequestQueue extensionRequestQueue) {
        this.extensionRequestQueue = extensionRequestQueue;
    }

    public void setRequestFrameInSecond(EzyRequestFrame requestFrameInSecond) {
        this.requestFrameInSecond = requestFrameInSecond;
    }

    public void setDelegate(EzySessionDelegate delegate) {
        this.delegate = delegate;
    }
}

