/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.entity;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.entity.EzyEntity;
import com.tvd12.ezyfox.function.EzyFunctions;
import com.tvd12.ezyfox.util.EzyNameAware;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.setting.EzyZoneIdAware;
import com.tvd12.ezyfoxserver.socket.EzyPacket;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class EzySimpleUser
extends EzyEntity
implements EzyUser,
EzyNameAware,
EzyZoneIdAware,
Serializable {
    private static final long serialVersionUID = -7846882289922504595L;
    protected long id = COUNTER.incrementAndGet();
    protected String name = "";
    protected String password = "";
    protected int zoneId = 0;
    protected int maxSessions = 30;
    protected long maxIdleTime = 180000L;
    protected long startIdleTime = System.currentTimeMillis();
    protected volatile boolean destroyed = false;
    protected Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    protected Map<Long, EzySession> sessionMap = new ConcurrentHashMap<Long, EzySession>();
    private static final AtomicLong COUNTER = new AtomicLong(0L);

    @Override
    public void addSession(EzySession session) {
        this.sessionMap.put(session.getId(), session);
    }

    @Override
    public void removeSession(EzySession session) {
        this.startIdleTime = System.currentTimeMillis();
        this.sessionMap.remove(session.getId());
    }

    @Override
    public List<EzySession> changeSession(EzySession session) {
        ConcurrentHashMap<Long, EzySession> newSessionMap = new ConcurrentHashMap<Long, EzySession>();
        newSessionMap.put(session.getId(), session);
        Map<Long, EzySession> oldSessionMap = this.sessionMap;
        this.sessionMap = newSessionMap;
        ArrayList<EzySession> answer = new ArrayList<EzySession>(oldSessionMap.values());
        oldSessionMap.clear();
        return answer;
    }

    @Override
    public EzySession getSession() {
        List<EzySession> sessions = this.getSessions();
        return sessions.isEmpty() ? null : sessions.get(0);
    }

    @Override
    public List<EzySession> getSessions() {
        ArrayList<EzySession> sessions = new ArrayList<EzySession>();
        Map<Long, EzySession> sessionMapNow = this.sessionMap;
        if (sessionMapNow != null) {
            sessions.addAll(sessionMapNow.values());
        }
        return sessions;
    }

    @Override
    public int getSessionCount() {
        return this.sessionMap.size();
    }

    @Override
    public Lock getLock(String name) {
        return this.locks.computeIfAbsent(name, EzyFunctions.NEW_REENTRANT_LOCK_FUNC);
    }

    @Override
    public void send(EzyPacket packet) {
        for (EzySession session : this.getSessions()) {
            session.send(packet);
        }
    }

    @Override
    public void sendNow(EzyPacket packet) {
        for (EzySession session : this.getSessions()) {
            session.sendNow(packet);
        }
    }

    @Override
    public boolean isIdle() {
        if (this.sessionMap.isEmpty()) {
            long offset = System.currentTimeMillis() - this.startIdleTime;
            return this.maxIdleTime < offset;
        }
        return false;
    }

    @Override
    public void disconnect(EzyConstant reason) {
        for (EzySession session : this.getSessions()) {
            session.disconnect(reason);
        }
    }

    public void destroy() {
        this.destroyed = true;
        if (this.locks != null) {
            this.locks.clear();
        }
        if (this.sessionMap != null) {
            this.sessionMap.clear();
        }
        this.properties.clear();
        this.locks = null;
        this.sessionMap = null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof EzySimpleUser) {
            return this.id == ((EzySimpleUser)obj).id;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return this.name;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setZoneId(int zoneId) {
        this.zoneId = zoneId;
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public void setStartIdleTime(long startIdleTime) {
        this.startIdleTime = startIdleTime;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public int getZoneId() {
        return this.zoneId;
    }

    @Override
    public int getMaxSessions() {
        return this.maxSessions;
    }

    @Override
    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public long getStartIdleTime() {
        return this.startIdleTime;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public Map<String, Lock> getLocks() {
        return this.locks;
    }

    public Map<Long, EzySession> getSessionMap() {
        return this.sessionMap;
    }
}

