/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfoxserver.setting.EzyAbstractSocketSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleSslConfigSetting;
import com.tvd12.ezyfoxserver.setting.EzyWebSocketSetting;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="web-socket")
public class EzySimpleWebSocketSetting
extends EzyAbstractSocketSetting
implements EzyWebSocketSetting {
    @XmlElement(name="ssl-port")
    protected int sslPort;
    @XmlElement(name="max-frame-size")
    protected int maxFrameSize;
    @XmlElement(name="writer-thread-pool-size")
    protected int writerThreadPoolSize;
    @XmlElement(name="ssl-config")
    protected EzySimpleSslConfigSetting sslConfig;
    @XmlElement(name="management-enable")
    protected boolean managementEnable;

    public EzySimpleWebSocketSetting() {
        this.setPort(2208);
        this.setSslPort(2812);
        this.setMaxFrameSize(2048);
        this.setWriterThreadPoolSize(8);
        this.setSslConfig(new EzySimpleSslConfigSetting());
        this.setCodecCreator("com.tvd12.ezyfox.codec.JacksonCodecCreator");
    }

    @Override
    public Map<Object, Object> toMap() {
        Map<Object, Object> map = super.toMap();
        map.put("maxFrameSize", this.maxFrameSize);
        map.put("sslPort", this.sslPort);
        map.put("sslActive", this.sslActive);
        map.put("sslConfig", this.sslConfig.toMap());
        map.put("managementEnable", this.managementEnable);
        map.put("writerThreadPoolSize", this.writerThreadPoolSize);
        return map;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setWriterThreadPoolSize(int writerThreadPoolSize) {
        this.writerThreadPoolSize = writerThreadPoolSize;
    }

    public void setSslConfig(EzySimpleSslConfigSetting sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void setManagementEnable(boolean managementEnable) {
        this.managementEnable = managementEnable;
    }

    @Override
    public int getSslPort() {
        return this.sslPort;
    }

    @Override
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public int getWriterThreadPoolSize() {
        return this.writerThreadPoolSize;
    }

    @Override
    public EzySimpleSslConfigSetting getSslConfig() {
        return this.sslConfig;
    }

    @Override
    public boolean isManagementEnable() {
        return this.managementEnable;
    }

    public String toString() {
        return "EzySimpleWebSocketSetting(sslPort=" + this.getSslPort() + ", maxFrameSize=" + this.getMaxFrameSize() + ", writerThreadPoolSize=" + this.getWriterThreadPoolSize() + ", sslConfig=" + this.getSslConfig() + ", managementEnable=" + this.isManagementEnable() + ")";
    }
}

