/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfoxserver.setting.EzySimpleZoneSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneSetting;
import com.tvd12.ezyfoxserver.setting.EzyZonesSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlElement;

public class EzySimpleZonesSetting
implements EzyZonesSetting {
    protected final List<EzyZoneSetting> zones = new ArrayList<EzyZoneSetting>();
    protected final Map<Integer, EzySimpleZoneSetting> zonesByIds = new ConcurrentHashMap<Integer, EzySimpleZoneSetting>();
    protected final Map<String, EzySimpleZoneSetting> zonesByNames = new ConcurrentHashMap<String, EzySimpleZoneSetting>();

    @XmlElement(name="zone")
    public void setItem(EzySimpleZoneSetting item) {
        this.zones.add(item);
        this.zonesByIds.put(item.getId(), item);
        this.zonesByNames.put(item.getName(), item);
    }

    @Override
    public Set<String> getZoneNames() {
        return this.zonesByNames.keySet();
    }

    @Override
    public Set<Integer> getZoneIds() {
        return this.zonesByIds.keySet();
    }

    @Override
    public EzySimpleZoneSetting getZoneByName(String name) {
        EzySimpleZoneSetting zoneSetting = this.zonesByNames.get(name);
        if (zoneSetting != null) {
            return zoneSetting;
        }
        throw new IllegalArgumentException("has no zone with name: " + name);
    }

    @Override
    public EzySimpleZoneSetting getZoneById(Integer id) {
        EzySimpleZoneSetting zoneSetting = this.zonesByIds.get(id);
        if (zoneSetting != null) {
            return zoneSetting;
        }
        throw new IllegalArgumentException("has no zone with id: " + id);
    }

    @Override
    public int getSize() {
        return this.zones.size();
    }

    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ArrayList<Map> zoneMaps = new ArrayList<Map>();
        for (EzyZoneSetting zone : this.zones) {
            zoneMaps.add(zone.toMap());
        }
        map.put("size", this.zones.size());
        map.put("zones", zoneMaps);
        return map;
    }

    @Override
    public List<EzyZoneSetting> getZones() {
        return this.zones;
    }

    public Map<Integer, EzySimpleZoneSetting> getZonesByIds() {
        return this.zonesByIds;
    }

    public Map<String, EzySimpleZoneSetting> getZonesByNames() {
        return this.zonesByNames;
    }

    public String toString() {
        return "EzySimpleZonesSetting(zones=" + this.getZones() + ", zonesByIds=" + this.getZonesByIds() + ", zonesByNames=" + this.getZonesByNames() + ")";
    }
}

