/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.socket.EzyPacket;
import com.tvd12.ezyfoxserver.socket.EzyPacketQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsQueue;
import com.tvd12.ezyfoxserver.socket.EzySessionTicketsQueueAware;
import com.tvd12.ezyfoxserver.socket.EzySocketAbstractEventHandler;
import com.tvd12.ezyfoxserver.socket.EzySocketWriterGroup;
import com.tvd12.ezyfoxserver.socket.EzySocketWriterGroupFetcher;

public class EzySocketWriter
extends EzySocketAbstractEventHandler
implements EzySessionTicketsQueueAware {
    protected EzySessionTicketsQueue sessionTicketsQueue;
    protected EzySocketWriterGroupFetcher writerGroupFetcher;

    @Override
    public void handleEvent() {
        try {
            Object session = this.sessionTicketsQueue.take();
            this.processSessionQueue((EzySession)session);
        }
        catch (InterruptedException e) {
            this.logger.info("socket-writer thread interrupted");
        }
        catch (Throwable e) {
            this.logger.info("problems in socket-writer, thread", e);
        }
    }

    public void destroy() {
        EzyProcessor.processWithLogException(() -> this.sessionTicketsQueue.clear());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionQueue(EzySession session) throws Exception {
        EzyPacketQueue queue;
        EzySocketWriterGroup group = this.writerGroupFetcher.getWriterGroup(session);
        if (group == null) {
            return;
        }
        EzyPacketQueue ezyPacketQueue = queue = session.getPacketQueue();
        synchronized (ezyPacketQueue) {
            boolean emptyQueue = this.processSessionQueue(group, queue);
            if (!emptyQueue) {
                this.sessionTicketsQueue.add(session);
            }
        }
    }

    private boolean processSessionQueue(EzySocketWriterGroup group, EzyPacketQueue queue) throws Exception {
        if (!queue.isEmpty()) {
            EzyPacket packet = queue.peek();
            Object writeBuffer = this.getWriteBuffer();
            group.firePacketSend(packet, writeBuffer);
            if (packet.isReleased()) {
                queue.take();
            }
            return queue.isEmpty();
        }
        return true;
    }

    protected Object getWriteBuffer() {
        return null;
    }

    @Override
    public void setSessionTicketsQueue(EzySessionTicketsQueue sessionTicketsQueue) {
        this.sessionTicketsQueue = sessionTicketsQueue;
    }

    public void setWriterGroupFetcher(EzySocketWriterGroupFetcher writerGroupFetcher) {
        this.writerGroupFetcher = writerGroupFetcher;
    }
}

