/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.ssl;

import com.tvd12.ezyfox.function.EzyExceptionApply;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public class EzySslContextProxy
extends EzyLoggable {
    private final Supplier<SSLContext> sslContextSupplier;
    private final List<EzyExceptionApply<SSLContext>> sslContextReloadListeners;

    public EzySslContextProxy(Supplier<SSLContext> sslContextSupplier) {
        this.sslContextSupplier = sslContextSupplier;
        this.sslContextReloadListeners = new ArrayList<EzyExceptionApply<SSLContext>>();
    }

    public SSLContext loadSslContext() {
        return this.sslContextSupplier.get();
    }

    public void onSslContextReload(EzyExceptionApply<SSLContext> listener) {
        this.sslContextReloadListeners.add(listener);
    }

    public void reloadSsl() {
        SSLContext newSslContext = this.loadSslContext();
        this.sslContextReloadListeners.forEach(listener -> {
            try {
                listener.apply((Object)newSslContext);
            }
            catch (Exception e) {
                this.logger.error("reload ssl context on listener: {} error", listener, (Object)e);
            }
        });
    }
}

