/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.entity;

import com.tvd12.gamebox.entity.LocatedPlayer;
import com.tvd12.gamebox.entity.Room;
import com.tvd12.gamebox.exception.NoSlotException;
import com.tvd12.gamebox.manager.DefaultLocatedPlayerManager;
import com.tvd12.gamebox.manager.LocatedPlayerManager;
import java.util.LinkedList;
import java.util.Queue;

public class LocatedRoom
extends Room {
    protected final int maxSlot;
    protected final LocatedPlayerManager playerManager;
    protected Queue<Integer> slots;

    public LocatedRoom(Builder<?> builder) {
        super(builder);
        this.maxSlot = builder.maxSlot;
        this.playerManager = builder.playerManager;
        this.slots = this.newSlots(builder.maxSlot);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public int addPlayer(LocatedPlayer player) {
        if (this.slots.isEmpty()) {
            throw new NoSlotException("has no available slot");
        }
        int location = this.slots.poll();
        this.playerManager.addPlayer(player, location);
        return location;
    }

    public void removePlayer(LocatedPlayer player) {
        if (this.playerManager.containsPlayer(player.getName())) {
            this.playerManager.removePlayer(player.getLocation());
            this.slots.add(player.getLocation());
        }
    }

    protected Queue<Integer> newSlots(int maxSlots) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (int i = 0; i < maxSlots; ++i) {
            slots.add(i);
        }
        return slots;
    }

    public int getMaxSlot() {
        return this.maxSlot;
    }

    public LocatedPlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public Queue<Integer> getSlots() {
        return this.slots;
    }

    public static class Builder<B extends Builder<B>>
    extends Room.Builder<B> {
        protected int maxSlot = 999;
        protected LocatedPlayerManager playerManager;

        public B maxSlot(int maxSlot) {
            this.maxSlot = maxSlot;
            return (B)this;
        }

        public B playerManager(LocatedPlayerManager playerManager) {
            this.playerManager = playerManager;
            return (B)this;
        }

        @Override
        protected void preBuild() {
            if (this.playerManager == null) {
                this.playerManager = new DefaultLocatedPlayerManager();
            }
        }

        @Override
        public LocatedRoom build() {
            return (LocatedRoom)super.build();
        }

        @Override
        protected LocatedRoom newProduct() {
            return new LocatedRoom(this);
        }
    }
}

