/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.entity;

import com.tvd12.gamebox.entity.MMOPlayer;
import com.tvd12.gamebox.entity.MMORoom;
import com.tvd12.gamebox.entity.Player;
import com.tvd12.gamebox.math.Vec3;
import com.tvd12.gamebox.octree.OcTree;
import com.tvd12.gamebox.octree.SynchronizedOcTree;
import java.util.List;

public class MMOOcTreeRoom
extends MMORoom {
    private final Vec3 leftBottomBack;
    private final Vec3 rightTopFront;
    private final OcTree<MMOPlayer> ocTree;

    public MMOOcTreeRoom(Builder builder) {
        super(builder);
        this.ocTree = new SynchronizedOcTree<MMOPlayer>(builder.leftBottomBack, builder.rightTopFront, builder.maxPointsPerNode, builder.minNodeSize);
        this.leftBottomBack = builder.leftBottomBack;
        this.rightTopFront = builder.rightTopFront;
    }

    public void setPlayerPosition(MMOPlayer player, Vec3 position) {
        boolean isSuccessful = !this.ocTree.contains(player) ? this.addNewPlayer(player, position) : this.updateExistingPlayer(player, position);
        if (!isSuccessful) {
            throw new IllegalArgumentException("Can't set " + player.getName() + " to position=" + position);
        }
        this.updateNearbyPlayers(player);
    }

    private void updateNearbyPlayers(MMOPlayer player) {
        this.clearCurrentNearbyPlayers(player);
        this.addNewNearbyPlayers(player);
    }

    private void clearCurrentNearbyPlayers(MMOPlayer player) {
        for (String otherPlayerName : player.getNearbyPlayerNames()) {
            MMOPlayer otherPlayer = (MMOPlayer)this.playerManager.getPlayer(otherPlayerName);
            otherPlayer.removeNearByPlayer(player);
        }
        player.clearNearByPlayers();
    }

    private void addNewNearbyPlayers(MMOPlayer player) {
        List<MMOPlayer> nearByPlayers = this.ocTree.search(player, (float)this.distanceOfInterest);
        nearByPlayers.forEach(nearbyPlayer -> {
            player.addNearbyPlayer((MMOPlayer)nearbyPlayer);
            nearbyPlayer.addNearbyPlayer(player);
        });
    }

    private boolean addNewPlayer(MMOPlayer player, Vec3 newPosition) {
        super.addPlayer(player);
        player.setPosition(newPosition);
        return this.ocTree.insert(player);
    }

    private boolean updateExistingPlayer(MMOPlayer player, Vec3 newPosition) {
        if (this.ocTree.isItemRemainingAtSameNode(player, newPosition)) {
            player.setPosition(newPosition);
            return true;
        }
        this.ocTree.remove(player);
        player.setPosition(newPosition);
        return this.ocTree.insert(player);
    }

    @Override
    public void removePlayer(Player player) {
        this.ocTree.remove((MMOPlayer)player);
        this.clearCurrentNearbyPlayers((MMOPlayer)player);
        super.removePlayer(player);
    }

    @Override
    protected void updatePlayers() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Vec3 getLeftBottomBack() {
        return this.leftBottomBack;
    }

    public Vec3 getRightTopFront() {
        return this.rightTopFront;
    }

    public static class Builder
    extends MMORoom.Builder {
        private Vec3 leftBottomBack;
        private Vec3 rightTopFront;
        private int maxPointsPerNode;
        private float minNodeSize = 1.0E-6f;

        public Builder leftBottomBack(Vec3 leftBottomBack) {
            this.leftBottomBack = leftBottomBack;
            return this;
        }

        public Builder rightTopFront(Vec3 rightTopFront) {
            this.rightTopFront = rightTopFront;
            return this;
        }

        public Builder maxPointsPerNode(int maxPointsPerNode) {
            this.maxPointsPerNode = maxPointsPerNode;
            return this;
        }

        public Builder minNodeSize(float minNodeSize) {
            this.minNodeSize = minNodeSize;
            return this;
        }

        @Override
        protected void preBuild() {
            super.preBuild();
            if (this.maxPointsPerNode <= 0) {
                throw new IllegalArgumentException("maxPointsPerNode must be set!");
            }
        }

        @Override
        public MMORoom.Builder distanceOfInterest(double distance) {
            this.distanceOfInterest = distance;
            return this;
        }

        @Override
        protected MMORoom newProduct() {
            return new MMOOcTreeRoom(this);
        }
    }
}

