/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.manager;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.gamebox.entity.Player;
import com.tvd12.gamebox.exception.MaxPlayerException;
import com.tvd12.gamebox.exception.PlayerExistsException;
import com.tvd12.gamebox.manager.PlayerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbstractPlayerManager<P extends Player>
implements PlayerManager<P> {
    protected final int maxPlayer;
    protected final Map<String, P> playerByName = this.newPlayerByNameMap();

    public AbstractPlayerManager(int maxPlayer) {
        this.maxPlayer = maxPlayer;
    }

    protected AbstractPlayerManager(Builder<?, ?> builder) {
        this.maxPlayer = builder.maxPlayer;
    }

    @Override
    public P getPlayer(String username) {
        return (P)((Player)this.playerByName.get(username));
    }

    @Override
    public P getPlayer(String username, Supplier<P> playerSupplier) {
        return (P)this.playerByName.computeIfAbsent(username, k -> (Player)playerSupplier.get());
    }

    @Override
    public P getFirstPlayer() {
        return (P)(this.playerByName.isEmpty() ? null : (Player)this.playerByName.values().iterator().next());
    }

    @Override
    public List<P> getPlayerList() {
        return new ArrayList<P>(this.playerByName.values());
    }

    @Override
    public void getPlayerList(List<P> buffer) {
        buffer.addAll(this.playerByName.values());
    }

    @Override
    public List<P> getPlayerList(Predicate<P> predicate) {
        return this.playerByName.values().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public List<String> getPlayerNames() {
        return new ArrayList<String>(this.playerByName.keySet());
    }

    @Override
    public boolean containsPlayer(String username) {
        return this.playerByName.containsKey(username);
    }

    @Override
    public void addPlayer(P player, boolean failIfAdded) {
        int count = this.playerByName.size();
        if (count >= this.maxPlayer) {
            throw new MaxPlayerException(((Player)player).getName(), count, this.maxPlayer);
        }
        String playerName = ((Player)player).getName();
        if (this.playerByName.containsKey(playerName) && failIfAdded) {
            throw new PlayerExistsException(playerName);
        }
        this.playerByName.put(playerName, player);
    }

    @Override
    public void addPlayers(Collection<P> players, boolean failIfAdded) {
        int count = this.playerByName.size();
        int nextCount = count + players.size();
        if (nextCount > this.maxPlayer) {
            throw new MaxPlayerException(players.size(), count, this.maxPlayer);
        }
        for (Player player : players) {
            if (!this.playerByName.containsKey(player.getName()) || !failIfAdded) continue;
            throw new PlayerExistsException(player.getName());
        }
        for (Player player : players) {
            this.playerByName.put(player.getName(), player);
        }
    }

    @Override
    public P removePlayer(P player) {
        if (player != null) {
            this.playerByName.remove(((Player)player).getName());
        }
        return player;
    }

    @Override
    public void removePlayers(Collection<P> players) {
        for (Player player : players) {
            this.playerByName.remove(player.getName());
        }
    }

    @Override
    public int getPlayerCount() {
        return this.playerByName.size();
    }

    @Override
    public boolean available() {
        return this.playerByName.size() < this.maxPlayer;
    }

    @Override
    public boolean isEmpty() {
        return this.playerByName.isEmpty();
    }

    @Override
    public int countPlayers(Predicate<P> tester) {
        return (int)this.playerByName.values().stream().filter(tester).count();
    }

    @Override
    public void forEach(Consumer<P> consumer) {
        this.playerByName.values().forEach(consumer);
    }

    @Override
    public List<P> filterPlayers(Predicate<P> tester) {
        return EzyLists.filter(this.playerByName.values(), tester);
    }

    @Override
    public void clear() {
        this.playerByName.clear();
    }

    protected Map<String, P> newPlayerByNameMap() {
        return new ConcurrentHashMap();
    }

    public String toString() {
        return "playerByName.size = " + this.playerByName.size();
    }

    @Override
    public int getMaxPlayer() {
        return this.maxPlayer;
    }

    public static abstract class Builder<U extends Player, B extends Builder<U, B>>
    implements EzyBuilder<PlayerManager<U>> {
        protected int maxPlayer = 999999;

        public B maxPlayer(int maxPlayer) {
            this.maxPlayer = maxPlayer;
            return (B)this;
        }

        public final PlayerManager<U> build() {
            this.preBuild();
            return this.newProduct();
        }

        protected void preBuild() {
        }

        protected abstract PlayerManager<U> newProduct();
    }
}

