/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.support.asm;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClassTree;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfoxserver.context.EzyContext;
import com.tvd12.ezyfoxserver.event.EzyUserSessionEvent;
import com.tvd12.ezyfoxserver.support.asm.EzyAbstractHandlerImplementer;
import com.tvd12.ezyfoxserver.support.asm.EzyAsmAbstractUncaughtExceptionHandler;
import com.tvd12.ezyfoxserver.support.asm.EzyAsmUncaughtExceptionHandler;
import com.tvd12.ezyfoxserver.support.handler.EzyUncaughtExceptionHandler;
import com.tvd12.ezyfoxserver.support.reflect.EzyExceptionHandlerMethod;
import com.tvd12.ezyfoxserver.support.reflect.EzyExceptionHandlerProxy;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;

public class EzyExceptionHandlerImplementer
extends EzyAbstractHandlerImplementer<EzyExceptionHandlerMethod> {
    private static boolean debug;
    protected final EzyExceptionHandlerProxy exceptionHandler;
    protected static final AtomicInteger COUNT;

    public EzyExceptionHandlerImplementer(EzyExceptionHandlerProxy exceptionHandler, EzyExceptionHandlerMethod handlerMethod) {
        super(handlerMethod);
        this.exceptionHandler = exceptionHandler;
    }

    public EzyUncaughtExceptionHandler implement() {
        try {
            return this.doImplement();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected EzyUncaughtExceptionHandler doImplement() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyClass superClass = new EzyClass(this.getSuperClass());
        String exceptionHandlerFieldContent = this.makeExceptionHandlerFieldContent();
        String setExceptionHandlerMethodContent = this.makeSetExceptionHandlerMethodContent();
        String handleExceptionMethodContent = this.makeHandleExceptionMethodContent();
        this.printComponentContent(implClassName);
        this.printComponentContent(exceptionHandlerFieldContent);
        this.printComponentContent(setExceptionHandlerMethodContent);
        this.printComponentContent(handleExceptionMethodContent);
        implClass.setSuperclass(pool.get(superClass.getName()));
        implClass.addField(CtField.make((String)exceptionHandlerFieldContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)setExceptionHandlerMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)handleExceptionMethodContent, (CtClass)implClass));
        Class answerClass = implClass.toClass();
        implClass.detach();
        EzyAsmUncaughtExceptionHandler handler = (EzyAsmUncaughtExceptionHandler)answerClass.newInstance();
        this.setRepoComponent(handler);
        return handler;
    }

    protected void setRepoComponent(EzyAsmUncaughtExceptionHandler handler) {
        handler.setExceptionHandler(this.exceptionHandler.getInstance());
    }

    protected String makeExceptionHandlerFieldContent() {
        return new EzyInstruction().append("private ").append(this.exceptionHandler.getClazz().getName()).append(" exceptionHandler").toString();
    }

    protected String makeSetExceptionHandlerMethodContent() {
        return new EzyFunction(this.getSetExceptionHandlerMethod()).body().append(new EzyInstruction("\t", "\n").append("this.exceptionHandler").equal().brackets(this.exceptionHandler.getClazz().getClazz()).append("arg0")).function().toString();
    }

    protected String makeHandleExceptionMethodContent() {
        EzyMethod method = this.getHandleExceptionMethod();
        EzyFunction function = new EzyFunction(method).throwsException();
        EzyFunction.EzyBody body = function.body();
        Class[] exceptionClasses = ((EzyExceptionHandlerMethod)this.handlerMethod).getExceptionClasses();
        EzyClassTree exceptionTree = new EzyClassTree(exceptionClasses);
        for (Class exceptionClass : exceptionTree.toList()) {
            EzyInstruction instructionIf = new EzyInstruction("\t", "\n", false).append("if(arg4 instanceof ").append(exceptionClass.getName()).append(") {");
            body.append(instructionIf);
            EzyInstruction instructionHandle = new EzyInstruction("\t\t", "\n");
            instructionHandle.append("this.exceptionHandler.").append(((EzyExceptionHandlerMethod)this.handlerMethod).getName()).bracketopen();
            this.appendHandleExceptionMethodArguments(instructionHandle, exceptionClass);
            instructionHandle.bracketclose();
            body.append(instructionHandle);
            body.append(new EzyInstruction("\t", "\n", false).append("}"));
        }
        body.append(new EzyInstruction("\t", "\n", false).append("else {"));
        body.append(new EzyInstruction("\t\t", "\n").append("throw arg4"));
        body.append(new EzyInstruction("\t", "\n", false).append("}"));
        return function.toString();
    }

    protected void appendHandleExceptionMethodArguments(EzyInstruction instruction, Class<?> exceptionClass) {
        super.appendHandleExceptionMethodArguments((EzyExceptionHandlerMethod)this.handlerMethod, instruction, exceptionClass, "arg2", "arg3", "arg4");
    }

    protected EzyMethod getSetExceptionHandlerMethod() {
        Method method = EzyMethods.getMethod(EzyAsmAbstractUncaughtExceptionHandler.class, (String)"setExceptionHandler", (Class[])new Class[]{Object.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getHandleExceptionMethod() {
        Method method = EzyMethods.getMethod(EzyAsmAbstractUncaughtExceptionHandler.class, (String)"handleException", (Class[])new Class[]{EzyContext.class, EzyUserSessionEvent.class, String.class, Object.class, Exception.class});
        return new EzyMethod(method);
    }

    protected Class<?> getSuperClass() {
        return EzyAsmAbstractUncaughtExceptionHandler.class;
    }

    protected String getImplClassName() {
        return this.exceptionHandler.getClassSimpleName() + "$" + ((EzyExceptionHandlerMethod)this.handlerMethod).getName() + "$ExceptionHandler$AutoImpl$" + COUNT.incrementAndGet();
    }

    protected void printComponentContent(String componentContent) {
        if (debug) {
            this.logger.debug("component content: \n{}", (Object)componentContent);
        }
    }

    public static void setDebug(boolean debug) {
        EzyExceptionHandlerImplementer.debug = debug;
    }

    static {
        COUNT = new AtomicInteger(0);
    }
}

