/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.management.data;

import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.handler.RequestHandler;
import com.tvd12.ezyhttp.server.core.request.RequestURI;
import com.tvd12.ezyhttp.server.management.data.JavaMethod;
import java.util.List;
import java.util.stream.Collectors;

public class ApiInformation {
    private final String uri;
    private final HttpMethod method;
    private final boolean management;
    private final boolean authenticated;
    private final boolean resource;
    private final String resourcePath;
    private final List<JavaMethod> handlers;

    public ApiInformation(RequestURI requestUri, List<RequestHandler> handlerMethods) {
        this.uri = requestUri.getUri();
        this.method = requestUri.getMethod();
        this.management = requestUri.isManagement();
        this.authenticated = requestUri.isAuthenticated();
        this.resource = requestUri.isResource();
        this.resourcePath = requestUri.getResourceFullPath();
        this.handlers = handlerMethods.stream().map(it -> new JavaMethod(it.getHandlerMethod())).collect(Collectors.toList());
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public boolean isManagement() {
        return this.management;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isResource() {
        return this.resource;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public List<JavaMethod> getHandlers() {
        return this.handlers;
    }
}

